/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.search;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.JiraCollectionUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.jira.addon.IUM.search.GroupBean;
import de.accxia.jira.addon.IUM.search.GroupResults;
import de.accxia.jira.addon.IUM.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/gsearch")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class SearchRestController {
    private static final Logger LOG = LoggerFactory.getLogger(SearchRestController.class);
    public static final String QUERY = "searchTerm";
    public static final int SET_SIZE = 10;
    private final ApplicationRoleManager applicationRoleManager;
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final GroupManager groupManager;

    public SearchRestController(CrowdService crowdService, GroupManager groupManager) {
        this.crowdService = crowdService;
        this.groupManager = groupManager;
        this.applicationRoleManager = (ApplicationRoleManager)ComponentLocator.getComponent(ApplicationRoleManager.class);
    }

    @Path(value="/groups")
    @GET
    @Produces(value={"application/json"})
    public Response searchByGroupName(@QueryParam(value="searchTerm") String searchTerm) {
        try {
            List<Group> groups;
            Set groupSet = this.applicationRoleManager.getGroupsForLicensedRoles();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)searchTerm)) {
                groups = new ArrayList<Group>(this.getAllGroups(groupSet.size() + 20));
            } else {
                searchTerm = StringUtils.escapeUnderscores(searchTerm);
                groups = new ArrayList<Group>(this.getAllGroups(searchTerm, groupSet.size() + 20));
            }
            groups = this.filterNoAccessGroupName(groups, groupSet);
            return Response.ok((Object)this.convertResultsToSelect2(groups)).build();
        }
        catch (Exception e) {
            LOG.info("Group search failed: " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    private GroupResults convertResultsToSelect2(List<Group> groups) {
        GroupResults groupResults = new GroupResults(GroupBean.convertToGroupBeans(groups));
        return groupResults;
    }

    private List<Group> filterNoAccessGroupName(List<Group> groups, Set<Group> groupSet) {
        Map<String, String> mapJiraGroups = groupSet.stream().collect(Collectors.toMap(Group::getName, Group::getName));
        List<Group> filterGroups = groups.stream().filter(grp -> !mapJiraGroups.containsKey(grp.getName())).limit(10L).collect(Collectors.toList());
        return filterGroups;
    }

    public Collection<Group> getAllGroups(int maxResults) {
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)restriction, 0, maxResults < 10 ? 10 : maxResults);
        return JiraCollectionUtils.convertIterableToCollection((Iterable)this.crowdService.search((Query)query));
    }

    public Collection<Group> getAllGroups(String searchTerm, int maxResults) {
        TermRestriction termRestriction = new TermRestriction(GroupTermKeys.NAME, MatchMode.CONTAINS, (Object)searchTerm);
        GroupQuery groupQuery = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)termRestriction, 0, maxResults < 10 ? 10 : maxResults);
        return JiraCollectionUtils.convertIterableToCollection((Iterable)this.crowdService.search((Query)groupQuery));
    }
}

