/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarUrls;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserResource;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.util.TextUtils;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.search.UserResults;
import de.accxia.jira.addon.IUM.servlet.filter.UserPickerResultsBean;
import de.accxia.jira.addon.IUM.servlet.filter.UserPickerUser;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnlicensedSiteAccess
public class IUMRestFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IUMRestFilter.class);
    public static final String ASSIGNABLE = "/rest/api/[\\d\\w]+/user/assignable/search";
    public static final String ASSIGNEE = "/rest/internal/[\\d\\w]+/users/assignee";
    public static final String MULTI_ASSIGNABLE = "/rest/api/[\\d\\w]+/user/assignable/multiProjectSearch";
    public static final String USER = "/rest/api/[\\d\\w]+/search/user";
    public static final String AGENTS = "/rest/servicedesk/([\\d\\w]+)/pages/people/agents/([\\d\\w]+)/search";
    public static final String AUTOMATION = "/rest/servicedesk/automation/[\\d\\w]+/components/then/([\\d\\w]+)/validate";
    public static final String AUTOMATION_VALIDATE = "/rest/servicedesk/automation/[\\d\\w]+/ruleset/[\\d\\w]+/expectedRevisionId/([\\d\\w]+(/validate)?)";
    public static final String WATCHERS = "/rest/api/[\\d\\.\\w]+/users/picker/filter";
    public static final String FIELDVALUE_ASSIGNABLE = "\\{\\\\\"assignee\\\\\":\\\\\"([\\w\\d]+)\\\\\"\\}";
    public static final Pattern PATTERN_ASSIGNABLE = Pattern.compile("/rest/api/[\\d\\w]+/user/assignable/search");
    public static final Pattern PATTERN_ASSIGNEE = Pattern.compile("/rest/internal/[\\d\\w]+/users/assignee");
    public static final Pattern PATTERN_MULTI_ASSIGNABLE = Pattern.compile("/rest/api/[\\d\\w]+/user/assignable/multiProjectSearch");
    public static final Pattern PATTERN_USER = Pattern.compile("/rest/api/[\\d\\w]+/search/user");
    public static final Pattern PATTERN_WATCHERS = Pattern.compile("/rest/api/[\\d\\.\\w]+/users/picker/filter");
    public static final Pattern PATTERN_AGENTS = Pattern.compile("/rest/servicedesk/([\\d\\w]+)/pages/people/agents/([\\d\\w]+)/search");
    public static final Pattern PATTERN_AUTOMATION = Pattern.compile("/rest/servicedesk/automation/[\\d\\w]+/components/then/([\\d\\w]+)/validate");
    public static final Pattern PATTERN_AUTOMATION_VALIDATE = Pattern.compile("/rest/servicedesk/automation/[\\d\\w]+/ruleset/[\\d\\w]+/expectedRevisionId/([\\d\\w]+(/validate)?)");
    public static final Pattern PATTERN_FIELDVALUE_ASSIGNABLE = Pattern.compile("\\{\\\\\"assignee\\\\\":\\\\\"([\\w\\d]+)\\\\\"\\}");
    private final UserManager userManager;
    private final UserSearchService userSearchService;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final ProjectManager projectManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final IssueManager issueManager;
    @ComponentImport
    private final AvatarService avatarService;
    @ComponentImport
    private final I18nHelper i18n;
    private static final PermissionSchemeManager permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
    private static final ProjectRoleManager projectRoleManager = (ProjectRoleManager)ComponentAccessor.getComponent(ProjectRoleManager.class);
    private static final GroupManager groupManager = ComponentAccessor.getGroupManager();

    @Inject
    public IUMRestFilter(ApplicationProperties applicationProperties, ProjectManager projectManager, PermissionManager permissionManager, IssueManager issueManager, AvatarService avatarService, I18nHelper i18n) {
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.avatarService = avatarService;
        this.i18n = i18n;
        this.userManager = ComponentAccessor.getUserManager();
        this.userSearchService = (UserSearchService)ComponentLocator.getComponent(UserSearchService.class);
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("IUMRestFilter initialized.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        try {
            if (StringUtils.isEmpty((CharSequence)httpServletRequest.getRequestURI())) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            if (PATTERN_ASSIGNABLE.matcher(httpServletRequest.getRequestURI()).matches()) {
                this.doSearchAssignable(httpServletRequest, httpServletResponse);
                return;
            }
            if (PATTERN_MULTI_ASSIGNABLE.matcher(httpServletRequest.getRequestURI()).matches()) {
                this.doSearchAssignable(httpServletRequest, httpServletResponse);
                return;
            }
            if (PATTERN_ASSIGNEE.matcher(httpServletRequest.getRequestURI()).matches()) {
                this.doSearchAssignee(httpServletRequest, httpServletResponse);
                return;
            }
            if (PATTERN_USER.matcher(httpServletRequest.getRequestURI()).matches()) {
                this.doSearchUser(httpServletRequest, httpServletResponse);
                return;
            }
            if (PATTERN_WATCHERS.matcher(httpServletRequest.getRequestURI()).matches()) {
                this.doSearchWatchers(httpServletRequest, httpServletResponse);
                return;
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private ApplicationUser extractAssigneeFromValidateContentBody(String contentBody) {
        ApplicationUser assignee = null;
        try {
            Matcher fieldValueAssignable = PATTERN_FIELDVALUE_ASSIGNABLE.matcher(contentBody);
            if (fieldValueAssignable.find()) {
                String user = fieldValueAssignable.groupCount() >= 1 ? fieldValueAssignable.group(1) : "";
                assignee = this.userManager.getUserByName(user);
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage());
        }
        return assignee;
    }

    private void doSearchAssignable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String uname = httpServletRequest.getParameter("username");
            String project1 = httpServletRequest.getParameter("project");
            String project2 = httpServletRequest.getParameter("projectKeys");
            String projectKeys = project1 != null ? project1 : project2;
            String username = uname != null ? uname : "";
            String maxResults = httpServletRequest.getParameter("maxResults");
            Project project = this.projectManager.getProjectByCurrentKey(projectKeys);
            UserSearchParams.Builder builder = new UserSearchParams.Builder(100).allowEmptyQuery(true);
            if (project != null) {
                builder.filterByProjectIds(Arrays.asList(project.getId()));
            }
            UserSearchParams userSearchParams = builder.includeActive(true).includeInactive(false).maxResults(Integer.valueOf(100)).build();
            List users = this.userSearchService.findUsers(username, userSearchParams);
            ArrayList<ApplicationUser> filterUsers = new ArrayList<ApplicationUser>();
            ArrayList<ApplicationUser> restUsers = new ArrayList<ApplicationUser>();
            users.stream().forEach(applicationUser -> {
                if (this.permissionManager.hasPermission(ProjectPermissions.ASSIGNABLE_USER, project, applicationUser)) {
                    filterUsers.add((ApplicationUser)applicationUser);
                } else {
                    restUsers.add((ApplicationUser)applicationUser);
                }
            });
            Pair<Set<String>, Set<String>> allowGroups4ProjectPermissionKey = this.getGroups4ProjectPermissionKey(project, ProjectPermissions.ASSIGNABLE_USER);
            this.applyFilteringByUserToFilterUsers(restUsers, filterUsers, (Set)allowGroups4ProjectPermissionKey.getLeft(), project);
            this.applyFilteringByGroupToFilterUsers(restUsers, filterUsers, (Set)allowGroups4ProjectPermissionKey.getRight(), project);
            List<UserBean> userBeanList = this.convertUsersToUserBeans(Locale.getDefault(), filterUsers);
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writeValueAsString(userBeanList);
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().write(jsonString);
            return;
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            httpServletResponse.setStatus(500);
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.getWriter().write("An error occurred: " + e.getMessage());
            return;
        }
    }

    private void doSearchAssignee(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String issueKey = httpServletRequest.getParameter("issueKey");
            String query = httpServletRequest.getParameter("query");
            String maxResults = httpServletRequest.getParameter("maxResults");
            MutableIssue issue = this.issueManager.getIssueObject(issueKey);
            Project project = issue.getProjectObject();
            UserSearchParams.Builder builder = new UserSearchParams.Builder(100).ignorePermissionCheck(false).allowEmptyQuery(true);
            if (project != null) {
                builder.filterByProjectIds(Arrays.asList(project.getId()));
            }
            UserSearchParams userSearchParams = builder.includeActive(true).includeInactive(false).maxResults(Integer.valueOf(100)).build();
            List users = this.userSearchService.findUsers(query, userSearchParams);
            ArrayList<ApplicationUser> filterUsers = new ArrayList<ApplicationUser>();
            ArrayList<ApplicationUser> restUsers = new ArrayList<ApplicationUser>();
            users.stream().forEach(applicationUser -> {
                if (this.permissionManager.hasPermission(ProjectPermissions.ASSIGNABLE_USER, project, applicationUser)) {
                    filterUsers.add((ApplicationUser)applicationUser);
                } else {
                    restUsers.add((ApplicationUser)applicationUser);
                }
            });
            Pair<Set<String>, Set<String>> allowGroups4ProjectPermissionKey = this.getGroups4ProjectPermissionKey(project, ProjectPermissions.ASSIGNABLE_USER);
            this.applyFilteringByUserToFilterUsers(restUsers, filterUsers, (Set)allowGroups4ProjectPermissionKey.getLeft(), project);
            this.applyFilteringByGroupToFilterUsers(restUsers, filterUsers, (Set)allowGroups4ProjectPermissionKey.getRight(), project);
            List<UserBean> userBeanList = this.convertUsersToUserBeans(Locale.getDefault(), filterUsers);
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writeValueAsString(new UserResults(userBeanList));
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().write(jsonString);
            return;
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            httpServletResponse.setStatus(500);
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.getWriter().write("An error occurred: " + e.getMessage());
            return;
        }
    }

    private void applyFilteringByUserToFilterUsers(List<ApplicationUser> restUsers, List<ApplicationUser> filterUsers, Set<String> allowUsers4ProjectPermissionKey, Project project) {
        Iterator<ApplicationUser> iterator = restUsers.iterator();
        while (iterator.hasNext()) {
            ApplicationUser applicationUser = iterator.next();
            if (!allowUsers4ProjectPermissionKey.contains(applicationUser.getKey())) continue;
            filterUsers.add(applicationUser);
            iterator.remove();
        }
    }

    private void applyFilteringByGroupToFilterUsers(List<ApplicationUser> restUsers, List<ApplicationUser> filterUsers, Set<String> allowGroups4ProjectPermissionKey, Project project) {
        String[] enableGroupNames = DAO.getIUMGroups().split(",");
        String[] disableGroupNames = DAO.getIUMGroupsDisabled().split(",");
        HashMap<String, String> iumGroups = new HashMap<String, String>();
        for (int i = 0; i < disableGroupNames.length; ++i) {
            iumGroups.put(disableGroupNames[i], enableGroupNames[i]);
        }
        restUsers.stream().forEach(applicationUser -> {
            if (filterUsers.size() < 20) {
                long count;
                Collection groupsForUser = groupManager.getGroupNamesForUser(applicationUser);
                long dGroupCount = Arrays.stream(disableGroupNames).filter(dGroup -> groupsForUser.contains(dGroup)).count();
                if (dGroupCount > 0L && (count = groupsForUser.stream().filter(group -> {
                    if (allowGroups4ProjectPermissionKey.contains(iumGroups.get(group))) {
                        return true;
                    }
                    return allowGroups4ProjectPermissionKey.contains(group);
                }).count()) > 0L) {
                    filterUsers.add((ApplicationUser)applicationUser);
                }
            }
        });
    }

    private Pair<Set<String>, Set<String>> getGroups4ProjectPermissionKey(Project project, ProjectPermissionKey projectPermissionKey) {
        Scheme permissionScheme = permissionSchemeManager.getSchemeFor(project);
        if (permissionScheme == null) {
            LOG.info("No permission scheme found for project: " + project.getKey());
            return Pair.of((Object)Collections.EMPTY_SET, (Object)Collections.EMPTY_SET);
        }
        Collection permissionEntities = permissionSchemeManager.getPermissionSchemeEntries(permissionScheme, projectPermissionKey);
        HashSet<String> setGroups = new HashSet<String>();
        HashSet<String> setUsers = new HashSet<String>();
        for (PermissionSchemeEntry entity : permissionEntities) {
            Long roleId;
            ProjectRole projectRole;
            LOG.debug("entity.getType(): " + entity.getType());
            if (entity.getType().equals("group")) {
                setGroups.add(entity.getParameter());
                LOG.info("Group " + entity.getParameter() + " has Assign Issues permission on project " + project.getKey());
            }
            if (!entity.getType().equals("projectrole") || (projectRole = projectRoleManager.getProjectRole(roleId = Long.valueOf(Long.parseLong(entity.getParameter())))) == null) continue;
            Set roleActors = projectRoleManager.getProjectRoleActors(projectRole, project).getRoleActors();
            for (RoleActor roleActor : roleActors) {
                if (roleActor.getType().equals("atlassian-group-role-actor")) {
                    setGroups.add(roleActor.getParameter());
                }
                if (!roleActor.getType().equals("atlassian-user-role-actor")) continue;
                setUsers.add(roleActor.getParameter());
            }
        }
        return Pair.of(setUsers, setGroups);
    }

    @Deprecated
    private List<String> groups4AssignIssuesPermission2(String enableGroups, String disableGroups, Project project) {
        ArrayList<String> retVal = new ArrayList<String>();
        Scheme permissionScheme = permissionSchemeManager.getSchemeFor(project);
        if (permissionScheme == null) {
            LOG.info("No permission scheme found for project: " + project.getKey());
            return retVal;
        }
        Collection permissionEntities = permissionSchemeManager.getPermissionSchemeEntries(permissionScheme, ProjectPermissions.ASSIGNABLE_USER);
        String[] enableGroupNames = enableGroups.split(",");
        String[] disableGroupNames = disableGroups.split(",");
        block0: for (int i = 0; i < enableGroupNames.length; ++i) {
            String groupName = enableGroupNames[i];
            Group group = groupManager.getGroup(groupName);
            if (group == null) continue;
            for (PermissionSchemeEntry entity : permissionEntities) {
                LOG.debug("entity.getType(): " + entity.getType());
                if (entity.getType().equals("group") && groupName.equals(entity.getParameter())) {
                    retVal.add(disableGroupNames[i]);
                    LOG.info("Group " + groupName + " has Assign Issues permission on project " + project.getKey());
                    continue block0;
                }
                if (!entity.getType().equals("projectrole")) continue;
                Long roleId = Long.parseLong(entity.getParameter());
                ProjectRole projectRole = projectRoleManager.getProjectRole(roleId);
                boolean found = false;
                if (projectRole != null) {
                    Set roleActors = projectRoleManager.getProjectRoleActors(projectRole, project).getRoleActors();
                    for (RoleActor roleActor : roleActors) {
                        if (!roleActor.getType().equals("atlassian-group-role-actor") || !roleActor.getParameter().equals(groupName)) continue;
                        retVal.add(disableGroupNames[i]);
                        LOG.info("Group " + groupName + " is part of project role " + projectRole.getName() + " which has Assign Issues permission in project " + project.getKey());
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                continue block0;
            }
        }
        return retVal;
    }

    private void doSearchUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String username = httpServletRequest.getParameter("username");
            String project1 = httpServletRequest.getParameter("project");
            String project2 = httpServletRequest.getParameter("projectKeys");
            String projectKeys = project1 != null ? project1 : project2;
            String maxResults = httpServletRequest.getParameter("maxResults");
            Project project = this.projectManager.getProjectByCurrentKey(projectKeys);
            UserSearchParams.Builder builder = new UserSearchParams.Builder(100).allowEmptyQuery(true);
            if (project != null) {
                builder.filterByProjectIds(Arrays.asList(project.getId()));
            }
            UserSearchParams userSearchParams = builder.includeActive(true).includeInactive(true).maxResults(Integer.valueOf(100)).build();
            Collection<Object> users = this.userSearchService.findUsers(username, userSearchParams);
            users = this.filterToProject(users, project, ProjectPermissions.ASSIGNABLE_USER);
            List<UserBean> userBeanList = this.convertUsersToUserBeans(Locale.getDefault(), users);
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writeValueAsString(userBeanList);
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().write(jsonString);
            return;
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            httpServletResponse.setStatus(500);
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.getWriter().write("An error occurred: " + e.getMessage());
            return;
        }
    }

    private void doSearchWatchers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String issueKey = httpServletRequest.getParameter("issueKey");
            String query = httpServletRequest.getParameter("query");
            String showAvatar = httpServletRequest.getParameter("showAvatar");
            String projectKeys = this.getProjectkeyFromIssuekey(issueKey);
            Project project = this.projectManager.getProjectByCurrentKey(projectKeys);
            UserSearchParams.Builder builder = new UserSearchParams.Builder(100).allowEmptyQuery(true);
            if (project != null) {
                builder.filterByProjectIds(Arrays.asList(project.getId()));
            }
            UserSearchParams userSearchParams = builder.includeActive(true).includeInactive(true).maxResults(Integer.valueOf(100)).build();
            List users = this.userSearchService.findUsers(query, userSearchParams);
            ArrayList<ApplicationUser> filterUsers = new ArrayList<ApplicationUser>();
            ArrayList<ApplicationUser> restUsers = new ArrayList<ApplicationUser>();
            users.stream().forEach(applicationUser -> {
                if (this.permissionManager.hasPermission(ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, project, applicationUser)) {
                    filterUsers.add((ApplicationUser)applicationUser);
                } else {
                    restUsers.add((ApplicationUser)applicationUser);
                }
            });
            Pair<Set<String>, Set<String>> allowGroups4ProjectPermissionKey = this.getGroups4ProjectPermissionKey(project, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS);
            this.applyFilteringByUserToFilterUsers(restUsers, filterUsers, (Set)allowGroups4ProjectPermissionKey.getLeft(), project);
            this.applyFilteringByGroupToFilterUsers(restUsers, filterUsers, (Set)allowGroups4ProjectPermissionKey.getRight(), project);
            UserPickerResultsBean userPickerResultsBean = this.convertUsersToUserPickerUser(query, true, filterUsers);
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writeValueAsString(userPickerResultsBean);
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().write(jsonString);
            return;
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            httpServletResponse.setStatus(500);
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.getWriter().write("An error occurred: " + e.getMessage());
            return;
        }
    }

    public void destroy() {
    }

    private Collection<ApplicationUser> filterToProject(Collection<ApplicationUser> users, Project project, ProjectPermissionKey projectPermissionKey) {
        if (project != null) {
            return users.stream().filter(applicationUser -> this.permissionManager.hasPermission(projectPermissionKey, project, applicationUser)).collect(Collectors.toList());
        }
        return users;
    }

    private List<UserBean> convertUsersToUserBeans(Locale aDefault, Collection<ApplicationUser> users) {
        ArrayList<UserBean> userBeanList = new ArrayList<UserBean>();
        for (ApplicationUser user : users) {
            userBeanList.add(new UserBean(this.createSelfLink(user), user.getKey(), user.getName(), user.getDisplayName(), true, user.getEmailAddress(), null, IUMRestFilter.getAvatarURLs(user), null));
        }
        return userBeanList;
    }

    private UserPickerResultsBean convertUsersToUserPickerUser(String query, boolean showAvatar, Collection<ApplicationUser> users) {
        boolean canShowEmailAddresses = true;
        int total = users.size();
        int showing = 0;
        ArrayList<UserPickerUser> userPickerUserList = new ArrayList<UserPickerUser>();
        for (ApplicationUser user : users) {
            String html = this.formatUser(user, query, canShowEmailAddresses);
            userPickerUserList.add(new UserPickerUser(user.getName(), ApplicationUsers.getKeyFor((ApplicationUser)user), user.getDisplayName(), html, showAvatar ? this.avatarService.getAvatarURL(user, user.getName(), Avatar.Size.SMALL) : null));
        }
        return new UserPickerResultsBean(userPickerUserList, this.i18n.getText("jira.ajax.autocomplete.user.more.results", String.valueOf(showing), String.valueOf(total)), total);
    }

    private static Map<String, URI> getAvatarURLs(ApplicationUser forUser) {
        Avatar avatar = ComponentAccessor.getAvatarService().getAvatar(forUser, forUser);
        return avatar != null ? AvatarUrls.getAvatarURLs((ApplicationUser)forUser, (Avatar)avatar) : null;
    }

    private URI createSelfLink(ApplicationUser forUser) {
        UriBuilder urlBuilder = UriBuilder.fromPath((String)this.applicationProperties.getBaseUrl()).path("rest").path(UserResource.class).queryParam("username", new Object[]{"{0}"});
        return urlBuilder.build(new Object[]{forUser.getUsername()});
    }

    private String formatUser(ApplicationUser user, String query, boolean canShoweEmailAddresses) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<strong>", "</strong>");
        delimeterInserter.setConsideredWhitespace(UserSearchUtilities.SEPARATORS_STRING);
        String[] terms = new String[]{query};
        String userFullName = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getDisplayName()), terms);
        String userName = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getName()), terms);
        StringBuilder sb = new StringBuilder();
        sb.append(userFullName);
        if (canShoweEmailAddresses) {
            String userEmail = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getEmailAddress()), terms);
            sb.append(" - ");
            sb.append(userEmail);
        }
        sb.append(" (");
        sb.append(userName);
        sb.append(")");
        return sb.toString();
    }

    String getProjectkeyFromIssuekey(String issuekey) {
        int index = issuekey.indexOf(45);
        if (index < 1) {
            throw new IllegalArgumentException("Somehow have an invalid issuekey: " + issuekey);
        }
        return issuekey.substring(0, index);
    }

    private Collection<ApplicationUser> filterUsersFromGroup(List<String> groups, Collection<ApplicationUser> users) {
        ArrayList<ApplicationUser> filterUsers = new ArrayList<ApplicationUser>();
        for (String group : groups) {
            Group groupObject = groupManager.getGroup(group);
            for (ApplicationUser user : users) {
                if (!groupManager.isUserInGroup(user, groupObject)) continue;
                filterUsers.add(user);
            }
        }
        return filterUsers;
    }

    private List<ApplicationUser> filterUsersFromIUMDisableGroup(Collection<ApplicationUser> users) {
        ArrayList<ApplicationUser> retVal = new ArrayList<ApplicationUser>();
        Group iumDisable = groupManager.getGroup(DAO.getIUMGroupsDisabled());
        for (ApplicationUser user : users) {
            if (!groupManager.isUserInGroup(user, iumDisable)) continue;
            retVal.add(user);
        }
        return retVal;
    }

    private Set<String> groups4AssignIssuesPermission(Project project) {
        HashSet<String> retVal = new HashSet<String>();
        Scheme permissionScheme = permissionSchemeManager.getSchemeFor(project);
        if (permissionScheme == null) {
            LOG.info("No permission scheme found for project: " + project.getKey());
            return retVal;
        }
        Collection permissionEntities = permissionSchemeManager.getPermissionSchemeEntries(permissionScheme, ProjectPermissions.ASSIGNABLE_USER);
        for (PermissionSchemeEntry entity : permissionEntities) {
            Long roleId;
            ProjectRole projectRole;
            LOG.debug("entity.getType(): " + entity.getType());
            if (entity.getType().equals("group")) {
                retVal.add(entity.getParameter());
                LOG.info("Group " + entity.getParameter() + " has Assign Issues permission on project " + project.getKey());
            }
            if (!entity.getType().equals("projectrole") || (projectRole = projectRoleManager.getProjectRole(roleId = Long.valueOf(Long.parseLong(entity.getParameter())))) == null) continue;
            Set roleActors = projectRoleManager.getProjectRoleActors(projectRole, project).getRoleActors();
            for (RoleActor roleActor : roleActors) {
                if (!roleActor.getType().equals("atlassian-group-role-actor")) continue;
                retVal.add(roleActor.getParameter());
            }
        }
        return retVal;
    }
}

