var IUMLogout = new function() {
	var self=this;
	var theTimer;
	let INTERVAL=15000;
	const DELTA=300;
	const ONE_MINUTE=60 * 1000;
    const ONE_SECOND=1 * 1000;
	const DEBUG=false;
	const IUM_CHECK_ACCESS_PING='jira_ium_check_access_ping'
	const IUM_CHECK_ACCESS_LOGOUT='jira_ium_check_access_logout'
    let the403Patch=0;

	var doDisabled=function(force){
		//debugger

		if(force){
			//clean - IUM_CHECK_ACCESS_PING/IUM_CHECK_ACCESS_LOGOUT
			self.theLastUserName=null;
			window.localStorage.removeItem(IUM_CHECK_ACCESS_PING);
			window.localStorage.removeItem(IUM_CHECK_ACCESS_LOGOUT);

			AJS.$(".ium_removal").show();
			AJS.$(".ium_queue").hide();

			return;
		}


		if(!force && self.theLastUserName){
			window.localStorage.removeItem(IUM_CHECK_ACCESS_PING)
			document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
		}else {
			document.location.href = AJS.contextPath() +"/login.action?os_destination=" +document.location.href +"&permissionViolation=true";
			// document.location.href=AJS.$("#log_out").attr("href");
		}
	}
	
	var checkApplicationAccess=function(){
		//1. header
		var userName=AJS.$("#header-details-user-fullname").attr("data-username");
		//2.meta
		if(!userName) {userName=AJS.$("meta[name='loggedInUser']").attr('content');}
		if(!userName) {userName=AJS.$("meta[name='ajs-remote-user']").attr('content');}

		if (typeof (userName)=="undefined"){
			clearInterval(theTimer);
		} else {
			self.theLastUserName=userName;
			var dateNow = Date.now();
			var dateStr = window.localStorage.getItem(IUM_CHECK_ACCESS_PING);
			var dateRef =null;
			if(dateStr){
				try {
					dateRef = JSON.parse(dateStr);
					var dateDiff = dateNow - dateRef.timestamp;
					if(DEBUG){
						console.log("CHK:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
					}

					if (((Math.abs(dateDiff - INTERVAL) > DELTA) && (dateDiff < INTERVAL + 2 * DELTA)) && (dateRef.username === userName)) {
						if(DEBUG){
							console.log("BKP:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
						}
						doProcessData(dateRef, false);
						return;
					}
				} catch (error) {
					console.error(error);
					dateRef =null;
				}
			}


			if(DEBUG){
				if(dateRef && dateRef.timestamp){
					console.log("NET:" +( new Date().toISOString().slice(-13, -5)) + " / " + ( new Date(dateRef.timestamp).toISOString().slice(-13, -5))  +  " Access diff " +(dateNow - dateRef.timestamp) );
				}else{
					console.log("NET:" +( new Date().toISOString().slice(-13, -5)));
				}
			}
			var contextPath = AJS.contextPath() || "";
			self.ajaxGetCall(contextPath + "/rest/IUM/latest/apps?username="+userName);
		}	
	}

	this.startLogoutWatcher=function(period,sync){
		the403Patch=0;
		// period = period ? period * ONE_MINUTE : ONE_MINUTE;
		sync = sync ? sync * ONE_SECOND : 25 * ONE_SECOND ;

		// period = period ? period * ONE_MINUTE : ONE_MINUTE;
		// INTERVAL =Math.ceil( period/4);
		// INTERVAL= INTERVAL<ONE_MINUTE ? INTERVAL :ONE_MINUTE;
		checkApplicationAccess()
		theTimer=setInterval(checkApplicationAccess, sync);

		window.addEventListener('storage', function(event) {
			// Check the changed key and react accordingly
			if (event.key === IUM_CHECK_ACCESS_LOGOUT) {
				let datRef =JSON.parse(event.newValue);
				if(self.theLastUserName === datRef.username){
					doDisabled(!!datRef.force);
				}
			}
		});
	}

    this.loadConfig4Watcher=function(){
        let url = AJS.contextPath() + "/rest/IUM/latest/apps/interval";
        jQuery.ajax({
            url : url,
            dataType : 'json',
            contentType: "application/json; charset=utf-8",
            async : true,
            success : function(data) {
                let duration = 1;
                let sync = 15;
                try{
                    duration=parseInt(data.duration);
                    sync=parseInt(data.sync);
                }catch (err){
                    duration=1;
                }
                IUMLogout.startLogoutWatcher(duration,sync);
            },
            error :function (xhr, textStatus, errorThrown ) {
                if(xhr.status==401){
                    console.warn("data="+ JSON.stringify(textStatus));
                    return;
                }

                let duration=1;
                let sync = 15;
                IUMLogout.startLogoutWatcher(duration,sync);
            }
        });
    }

	var callDisabledOrLogout=function(force){

		clearInterval(theTimer);
		var dateRef={username:self.theLastUserName, timestamp:Date.now(),force:force};
		window.localStorage.setItem(IUM_CHECK_ACCESS_LOGOUT,JSON.stringify(dateRef));
		doDisabled(force);
		console.log("ACCXIA IUM: User has been logged out");
	}

	var doProcessData=function(data,withSaving){
		if (!data ){
			callDisabledOrLogout();
			return
		}
		// console.warn("data="+ JSON.stringify(data));
		if (Object.keys(data).length==0){
			callDisabledOrLogout();
			return;
		}
		try {
			//1. service desk | software
			if(!data["jira-servicedesk"] && !data["jira-software"] && !data["jira-core"] ){
				callDisabledOrLogout();
				return;
			}

			var msg = "";
			if(data["could-has-software"] &&  !data["jira-software"] ){
				msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-software ");
			}

			if(data["could-has-service"] &&  !data["jira-servicedesk"] ){
				msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-servicedesk ");
			}

			if(data["could-has-core"] &&  !data["jira-core"] ){
				msg = AJS.I18n.getText('de.accxia.apps.jira.IUM.lost.access.warning',  "jira-core ");
			}

			if(msg) {
				doPopupPartialPermission(msg);
			}else{
				IUMLogin && IUMLogin.doClosePopupFlag();
				IUMLogin && IUMLogin.doCleanRemindFlag();
				olderMessage=null;
			}

		}finally {
			if(withSaving){
				data.timestamp = Date.now();
				window.localStorage.setItem(IUM_CHECK_ACCESS_PING,JSON.stringify(data));
				if(DEBUG){
					console.log("SAVE:" + ( new Date(data.timestamp).toISOString().slice(-13, -5))  +  " data=" +JSON.stringify(data) );
				}
			}
		}
	}

	this.ajaxGetCall = function(url) {
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				doProcessData(data,true)
			},
			error :function (xhr, ajaxOptions, thrownError) {
				if (xhr.status >= 400 || errorThrown ) {
					// {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
					if(xhr.status==401){
						callDisabledOrLogout(true);
						return;
					}

					callDisabledOrLogout();
				}
			}
		});
	};

	let olderMessage;
	let doPopupPartialPermission=function(message){
		if(!IUMLogin.login_flag_hide || (message && message != olderMessage)){
			olderMessage=message;
			IUMLogin.doClosePopupFlag();

			IUMLogin.login_flag = AJS.flag({
				type: 'warning',
				title:'Intelligent User Manager (IUM)',
				body:message +
					'<ul class="aui-nav-actions-list">' +
					'<li><a class="aui-button aui-button-link" onclick="IUMLogout.doCloseAndRetryFlag()" href="#">Retry</a></li>' +
					'</ul>'
			});
			IUMLogin.login_flag_hide=false;
		}

	};


};

IUMLogout.doCloseAndRetryFlag=function(){

	jQuery.ajax({
		url : AJS.contextPath() + "/rest/IUM/latest/retry",
		dataType : 'json',
		contentType: "application/json; charset=utf-8",
		success : function(data) {
			if(data && data.warningMessage){
				IUMLogin.doUpdateCookie(data.warningMessage);
				IUMLogin.startIUMLoginWatcher();
			}else{

				IUMLogin.doCleanRemindFlag();
				IUMLogin.doPopupFullPermission()
			}
		},
		error :function (xhr, textStatus, errorThrown ) {
			if ((xhr && xhr.status >= 400) || errorThrown ) {
				console.error(xhr);
			}
		}
	});

	return false;
}

AJS.$( document ).ready(function() {
    // TODO PING 1min
    IUMLogout.loadConfig4Watcher();
    // IUMLogout.startLogoutWatcher(1);

	document.addEventListener('aui-flag-close', function(e) {
		if(IUMLogin.login_flag /*&& IUMLogin.login_flag == IUMLogin.login_flag*/ ){
			IUMLogin.login_flag_hide=true;
		}
	});

});
