/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.exception.RemoveException;
import de.accxia.jira.addon.IUM.analytical.CounterActionEventType;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.PublisherHelper;
import de.accxia.jira.addon.IUM.job.IJob;
import de.accxia.jira.addon.IUM.job.ProcessResult;
import de.accxia.jira.addon.IUM.model.AlertType;
import de.accxia.jira.addon.IUM.repository.IUMAlertRepository;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import de.accxia.jira.addon.IUM.repository.PocketRepository;
import de.accxia.jira.addon.IUM.servlet.HelperTrialProcessing;
import de.accxia.jira.addon.IUM.side.VerifyMessage;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMMembershipJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMMembershipJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMMembershipJob instance;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private IUMAlertRepository alertRepository;
    private HelperTrialProcessing helperTrialProcessing;
    int syncUsers = 0;

    private IUMMembershipJob() {
    }

    public static IUMMembershipJob getInstance() {
        if (instance == null) {
            instance = new IUMMembershipJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, PocketRepository pocketRepository, JobResultRepository jobResultRepository) {
        IUMMembershipJob.instance.helperTrialProcessing = helperTrialProcessing;
        IUMMembershipJob.instance.pocketRepository = pocketRepository;
        IUMMembershipJob.instance.jobResultRepository = jobResultRepository;
    }

    @Override
    public void injectService(IUMAlertRepository alertRepository) {
        IUMMembershipJob.instance.alertRepository = alertRepository;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) throws RemoveException {
        List<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMMembershipJob Process #[" + SDF.format(new Date()) + "] ");
        }
        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();
        String queueSize = DAO.getQueueSize();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMMembershipJob check groups ={} <=> {} at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (!StringUtils.isEmpty((CharSequence)targetGroup)) {
            VerifyMessage.LicenseStatus licenseStatus = ConditionEvaluatorImpl.computeLicenseStatus();
            if (licenseStatus == VerifyMessage.LicenseStatus.LICENSE_STATUS_FREE) {
                processResultList = this.helperTrialProcessing.adjustStatus4FreeVersion((String)((Object)parameters.get("current_user")));
                this.helperTrialProcessing.markMembershipChanges(AlertType.ALERT_JOBS_MEMBERSHIP, (String)((Object)parameters.get("current_user")), true, processResultList);
                for (ProcessResult processResult : processResultList) {
                    if (processResult.getAdjustSeats() > 0) {
                        PublisherHelper.emitCounterActionEvent(CounterActionEventType.ANALYTICAL_EVENT_REDUCED_EXCEED, processResult.getAdjustSeats(), null, processResult.getSourceGroups());
                    }
                    if (processResult.getUserRemoved() <= 0L) continue;
                    PublisherHelper.emitCounterActionEvent(CounterActionEventType.ANALYTICAL_EVENT_AUTO_REMOVAL, (int)processResult.getUserRemoved(), null, processResult.getSourceGroups());
                }
            }
            if (licenseStatus == VerifyMessage.LicenseStatus.LICENSE_STATUS_EXCEED) {
                processResultList = this.helperTrialProcessing.infoStatus4ExceedVersion((String)((Object)parameters.get("current_user")));
                int licenseSize = ConditionEvaluatorImpl.getSideLicense().getUsers();
                this.helperTrialProcessing.markMembershipWarn(AlertType.ALERT_JOBS_MEMBERSHIP, licenseSize, (String)((Object)parameters.get("current_user")), processResultList);
            } else {
                processResultList = this.helperTrialProcessing.adjustStatus4NormalVersion((String)((Object)parameters.get("current_user")));
                this.helperTrialProcessing.markMembershipChanges(AlertType.ALERT_JOBS_MEMBERSHIP, (String)((Object)parameters.get("current_user")), false, processResultList);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMMembershipJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }
}

