/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.job;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.jira.addon.IUM.job.IUMSyncJob;
import de.accxia.jira.addon.IUM.job.JobData;
import de.accxia.jira.addon.IUM.job.JobDataUtils;
import de.accxia.jira.addon.IUM.job.MonitorJobRunner;
import de.accxia.jira.addon.IUM.model.JobResult;
import de.accxia.jira.addon.IUM.model.JobResultDTO;
import de.accxia.jira.addon.IUM.repository.JobResultRepository;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={JobSyncService.class})
@Named(value="jobSyncService")
public class JobSyncService {
    private static final Logger LOG = LoggerFactory.getLogger(JobSyncService.class);
    private final MonitorJobRunner monitorJobRunner;
    private final JobResultRepository jobResultRepository;
    private final ApplicationRoleManager applicationRoleManager;
    private static UserUtil userUtil = ComponentAccessor.getUserUtil();

    @Inject
    public JobSyncService(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, ApplicationRoleManager applicationRoleManager) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.applicationRoleManager = applicationRoleManager;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobSyncService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMSyncJobData(), IUMSyncJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean restart() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobSyncService call restart");
            }
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            JobData jobData = JobDataUtils.createIUMSyncJobData();
            jobData.getParameters().put("restart", Boolean.TRUE);
            this.monitorJobRunner.doSchedule(jobData, IUMSyncJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JobSyncService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error("Exception" + msg, (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMSyncJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMSyncJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMSyncJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMSyncJob.class);
    }

    public List<JobResultDTO> findLatest(int idx, int ctx) {
        JobResult[] jobResults = this.jobResultRepository.findAll(new String[]{"SyncJob"}, idx, ctx);
        List<JobResultDTO> jobResultDTOList = Arrays.stream(jobResults).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return jobResultDTOList;
    }
}

