/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.api.config.IdpConfig;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.oidc.OidcConfig;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.repository.ConfigRepository;
import de.accxia.jira.addon.IUM.servlet.filter.XSSHttpServletRequestWrapper;
import de.accxia.jira.addon.IUM.utils.ParseUtil;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class IntelligentUserManagerOIDCFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerOIDCFilter.class);
    @ComponentImport
    private final IdpConfigService idpConfigService;
    private final ConfigRepository configRepository;

    @Inject
    public IntelligentUserManagerOIDCFilter(IdpConfigService idpConfigService, ConfigRepository configRepository) {
        this.idpConfigService = idpConfigService;
        this.configRepository = configRepository;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)DAO.getIdpConfig())) {
            chain.doFilter(request, response);
            return;
        }
        XSSHttpServletRequestWrapper xssRequest = new XSSHttpServletRequestWrapper((HttpServletRequest)request);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String code = xssRequest.getParameter("code");
        String state = xssRequest.getParameter("state");
        if (code == null || state == null) {
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("OIDC call code={} state={}", (Object)code, (Object)state);
        }
        IdpConfig idpConfig = null;
        try {
            OidcConfig oidcConfig;
            List idpConfigs = this.idpConfigService.getIdpConfigs();
            long idConfig = ParseUtil.safeParseInt(DAO.getIdpConfig(), 0);
            idpConfig = idpConfigs.stream().filter(idc -> idc.getId() == idConfig).findFirst().orElse(null);
            if (idpConfig != null && idpConfig instanceof OidcConfig && !(oidcConfig = (OidcConfig)idpConfig).isIncludeCustomerLogins()) {
                this.configRepository.updateById(idpConfig.getId(), true);
                idpConfigs = this.idpConfigService.getIdpConfigs();
                idpConfig = (IdpConfig)idpConfigs.get(2);
            }
        }
        catch (Exception e) {
            LOG.error("Exception=" + e.getMessage(), (Throwable)e);
        }
        if (idpConfig == null) {
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("OIDC idpConfig code={} isIncludeCustomerLogins={}", (Object)idpConfig, (Object)idpConfig.isIncludeCustomerLogins());
            }
            chain.doFilter((ServletRequest)xssRequest, response);
            return;
        }
        catch (Exception e) {
            LOG.error("Exception" + e.getMessage(), (Throwable)e);
            return;
        }
    }
}

