/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.event.user.LogoutEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.config.JobRunnerKey;
import de.accxia.jira.addon.IUM.analytical.CounterActionEvent;
import de.accxia.jira.addon.IUM.analytical.CounterActionEventType;
import de.accxia.jira.addon.IUM.conditions.ConditionEvaluatorImpl;
import de.accxia.jira.addon.IUM.config.DAO;
import de.accxia.jira.addon.IUM.impl.IntelligentUserManagerHelper;
import de.accxia.jira.addon.IUM.job.JobClusterService;
import de.accxia.jira.addon.IUM.job.JobDailyEventService;
import de.accxia.jira.addon.IUM.job.JobDailyService;
import de.accxia.jira.addon.IUM.job.JobLicenseService;
import de.accxia.jira.addon.IUM.job.JobMembershipService;
import de.accxia.jira.addon.IUM.job.JobSyncService;
import de.accxia.jira.addon.IUM.job.JobWatchService;
import de.accxia.jira.addon.IUM.repository.NavUserRepository;
import de.accxia.jira.addon.IUM.utils.StringUtils;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@ExportAsService(value={IUMListener.class})
@Named(value="IUMListener")
@EventComponent
public class IUMListener
implements InitializingBean,
DisposableBean,
ClusterMessageConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(IUMListener.class);
    private static final String PLUGIN_KEY = "de.accxia.jira.addon.IUM.IntelligentUserManager";
    public static Boolean PLUGIN_ENABLED = false;
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final ClusterManager clusterManager;
    @ComponentImport
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @ComponentImport
    private final ClusterMessagingService clusterMessagingService;
    private final DAO dao;
    private final NavUserRepository navUserRepository;
    @ComponentImport
    private final LoggingManager loggingManager;
    private final JobClusterService jobClusterService;
    private final JobWatchService jobWatchService;
    private final JobSyncService jobSyncService;
    private final JobDailyService jobDailyService;
    private final JobMembershipService jobMembershipService;
    private final JobDailyEventService jobDailyEventService;
    private final JobLicenseService jobLicenseService;
    private static String buffer4SideLicense;
    private static String buffer4RestAPI;

    @Inject
    public IUMListener(EventPublisher eventPublisher, ClusterManager clusterManager, ClusterMessagingService clusterMessagingService, JiraAuthenticationContext jiraAuthenticationContext, LoggingManager loggingManager, JobClusterService jobClusterService, JobWatchService jobWatchService, JobSyncService jobSyncService, JobDailyService jobDailyService, NavUserRepository navUserRepository, DAO dao, JobMembershipService jobMembershipService, JobDailyEventService jobDailyEventService, JobLicenseService jobLicenseService) {
        this.eventPublisher = eventPublisher;
        this.clusterManager = clusterManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jobClusterService = jobClusterService;
        this.jobSyncService = jobSyncService;
        this.jobDailyService = jobDailyService;
        this.jobWatchService = jobWatchService;
        this.navUserRepository = navUserRepository;
        this.dao = dao;
        this.clusterMessagingService = clusterMessagingService;
        this.loggingManager = loggingManager;
        this.jobMembershipService = jobMembershipService;
        this.jobDailyEventService = jobDailyEventService;
        this.jobLicenseService = jobLicenseService;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        this.clusterMessagingService.registerListener("IUMChannel", (ClusterMessageConsumer)this);
        PLUGIN_ENABLED = true;
        ConditionEvaluatorImpl.setSideLicense();
        if ("on".equalsIgnoreCase(DAO.getSyncWorkingJob()) && !this.jobSyncService.isWorking()) {
            this.jobSyncService.restart();
        }
        if ("on".equalsIgnoreCase(DAO.getWorkingJob()) && !this.jobClusterService.isWorking()) {
            this.jobClusterService.restart();
        }
        if ("on".equalsIgnoreCase(DAO.getWatcherJob()) && !this.jobWatchService.isWorking()) {
            this.jobWatchService.restart();
        }
        if (DAO.getLoggerLevel().booleanValue()) {
            LOG.warn("setLoggerLevel=TRUE");
            this.loggingManager.setLogLevel("de.accxia.jira.addon.IUM", "DEBUG");
        }
        if (!this.jobDailyService.isWorking()) {
            this.jobDailyService.start();
        }
        if (!this.jobDailyEventService.isWorking()) {
            this.jobDailyEventService.start();
        }
        if (!this.jobLicenseService.isWorking()) {
            this.jobLicenseService.start();
        }
        if (!this.jobMembershipService.isWorking()) {
            this.jobMembershipService.start();
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        this.clusterMessagingService.unregisterListener("IUMChannel", (ClusterMessageConsumer)this);
        try {
            if (this.jobSyncService.isWorking()) {
                this.jobSyncService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            if (this.jobClusterService.isWorking()) {
                this.jobClusterService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            if (this.jobWatchService.isWorking()) {
                this.jobWatchService.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobDailyService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobDailyEventService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobLicenseService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.jobMembershipService.stop();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        PLUGIN_ENABLED = false;
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        String pluginKey = event.getPlugin().getKey();
        if (PLUGIN_KEY.equals(pluginKey)) {
            PLUGIN_ENABLED = true;
        }
    }

    @PluginEventListener
    public void onPluginDisabling(PluginDisablingEvent event) {
        String pluginKey = event.getPlugin().getKey();
        if (PLUGIN_KEY.equals(pluginKey)) {
            PLUGIN_ENABLED = false;
        }
    }

    public void publishJobNotification(boolean isStarted) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("IUMListener publishJobNotification isStarted=" + isStarted);
        }
        this.clusterMessagingService.sendRemote("IUMChannel", "workingJob;" + isStarted);
    }

    public void publishWatcherNotification(boolean isStarted) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("IUMListener publishWatcherNotification isStarted=" + isStarted);
        }
        this.clusterMessagingService.sendRemote("IUMChannel", "watcherJob;" + isStarted);
    }

    public void publishSyncJobNotification(boolean isStarted) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("IUMListener publishJobNotification isStarted=" + isStarted);
        }
        this.clusterMessagingService.sendRemote("IUMChannel", "workingSyncJob;" + isStarted);
    }

    public void publishSyncRESTApi(String restAPI) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("IUMListener publishSyncRESTApi restAPI=" + restAPI);
        }
        if (restAPI != null) {
            List<String> chunks = StringUtils.splitIntoChunks(restAPI, 180);
            this.clusterMessagingService.sendRemote("IUMChannel", "REST_API_NO;" + String.valueOf(chunks.size()));
            for (int i = 0; i < chunks.size(); ++i) {
                this.clusterMessagingService.sendRemote("IUMChannel", "REST_API_BODY;" + String.valueOf(i) + ";" + chunks.get(i));
            }
            this.clusterMessagingService.sendRemote("IUMChannel", "REST_API_END;" + String.valueOf(chunks.size()));
        }
    }

    public void publishSyncSideLicense(String sideLicense) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("IUMListener publishSyncSideLicense sideLicense=" + sideLicense);
        }
        if (sideLicense == null) {
            this.clusterMessagingService.sendRemote("IUMChannel", "SIDE_LICENSE_NO;0");
            this.clusterMessagingService.sendRemote("IUMChannel", "SIDE_LICENSE_BODY;0;");
        } else {
            List<String> chunks = StringUtils.splitIntoChunks(sideLicense, 180);
            this.clusterMessagingService.sendRemote("IUMChannel", "SIDE_LICENSE_NO;" + String.valueOf(chunks.size()));
            for (int i = 0; i < chunks.size(); ++i) {
                this.clusterMessagingService.sendRemote("IUMChannel", "SIDE_LICENSE_BODY;" + String.valueOf(i) + ";" + chunks.get(i));
            }
            this.clusterMessagingService.sendRemote("IUMChannel", "SIDE_LICENSE_END;" + String.valueOf(chunks.size()));
        }
    }

    private static org.apache.log4j.Logger getLogger(String loggerName) {
        return "root".equals(loggerName) ? org.apache.log4j.Logger.getRootLogger() : org.apache.log4j.Logger.getLogger((String)loggerName);
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        ApplicationUser user;
        if (ConditionEvaluatorImpl.isLicenseValid() && (user = logoutEvent.getUser()) != null) {
            List<String> groupNames = IntelligentUserManagerHelper.moveUserToDisabled(user);
            if (DAO.getAuditStatus() && groupNames.size() > 0) {
                for (String groupName : groupNames) {
                    this.eventPublisher.publish((Object)CounterActionEvent.createCounterActionEvent4Type(CounterActionEventType.ANALYTICAL_EVENT_LOGOUT, user.getName(), groupName));
                }
            }
        }
    }

    public void receive(String channel, String message, String senderId) {
        LOG.warn("IUMListener receive=" + channel + "=" + message + ": " + senderId);
        LOG.warn("IUMListener getNodeId=" + this.clusterManager.getNodeId());
        if (message != null && !senderId.equals(this.clusterManager.getNodeId())) {
            Integer no;
            String[] parts;
            if (message.startsWith("workingJob")) {
                String[] parts2 = message.split(";");
                Boolean isStarted = Boolean.valueOf(parts2[1]);
                if (isStarted.booleanValue()) {
                    this.jobClusterService.start();
                    LOG.warn("IUMListener Job isStarted = " + isStarted);
                } else {
                    this.jobClusterService.stop();
                    LOG.warn("IUMListener Job isStopped = " + isStarted);
                }
                return;
            }
            if (message.startsWith("watcherJob")) {
                String[] parts3 = message.split(";");
                Boolean isStarted = Boolean.valueOf(parts3[1]);
                if (isStarted.booleanValue()) {
                    this.jobWatchService.start();
                    LOG.warn("IUMListener Job isStarted = " + isStarted);
                } else {
                    this.jobWatchService.stop();
                    LOG.warn("IUMListener Job isStopped = " + isStarted);
                }
                return;
            }
            if (message.startsWith("workingSyncJob")) {
                String[] parts4 = message.split(";");
                Boolean isStarted = Boolean.valueOf(parts4[1]);
                if (isStarted.booleanValue()) {
                    this.jobSyncService.start();
                    LOG.warn("IUMListener Sync isStarted = " + isStarted);
                } else {
                    this.jobSyncService.stop();
                    LOG.warn("IUMListener Sync isStopped = " + isStarted);
                }
                return;
            }
            if (message.startsWith("REST_API_NO")) {
                parts = message.split(";");
                no = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                buffer4RestAPI = "";
            }
            if (message.startsWith("REST_API_BODY")) {
                parts = message.split(";");
                String restAPI = parts.length > 2 ? parts[2] : "";
                buffer4RestAPI = buffer4RestAPI + restAPI;
                return;
            }
            if (message.startsWith("REST_API_END")) {
                parts = message.split(";");
                DAO.updateUrlRest(buffer4RestAPI);
                buffer4RestAPI = "";
                return;
            }
            if (message.startsWith("SIDE_LICENSE_NO")) {
                parts = message.split(";");
                no = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                if (no == 0) {
                    ConditionEvaluatorImpl.deleteSideLicense();
                } else {
                    buffer4SideLicense = "";
                }
            }
            if (message.startsWith("SIDE_LICENSE_BODY")) {
                parts = message.split(";");
                String sideLicense = parts.length > 2 ? parts[2] : "";
                buffer4SideLicense = buffer4SideLicense + sideLicense;
                return;
            }
            if (message.startsWith("SIDE_LICENSE_END")) {
                parts = message.split(";");
                ConditionEvaluatorImpl.setSideLicense(buffer4SideLicense);
                buffer4SideLicense = "";
                return;
            }
        }
    }

    class JobRunnerKeyDetail {
        public JobRunnerKey jobRunnerKey;
        public Date nextRunDate = null;

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey, Date nextRunDate) {
            this.jobRunnerKey = jobRunnerKey;
            this.nextRunDate = nextRunDate;
        }

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey) {
            this(jobRunnerKey, null);
        }

        public JobRunnerKeyDetail(String className) {
            this.jobRunnerKey = JobRunnerKey.of((String)className);
            this.nextRunDate = null;
        }
    }
}

