/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.jira.addon.IUM.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JSONUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static Map<String, Object> convertToGenericStructure(String jsonString) {
        LinkedHashMap<String, Object> result = new LinkedHashMap();
        try {
            JsonNode rootNode = objectMapper.readTree(jsonString);
            result = JSONUtil.convertToGenericStructure(rootNode);
        }
        catch (Exception e) {
            LOG.error("Error processing JSON: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static List<String> getAllValueForKey(Map<String, Object> structure, String key) {
        ArrayList<String> valueForKey = new ArrayList<String>();
        try {
            List<Map<String, Object>> results = JSONUtil.searchForKey(structure, key);
            for (Map<String, Object> result : results) {
                if (!result.containsKey("name") || !result.containsKey("value") || !result.containsKey("type") || !result.get("name").equals(key) || !(result.get("value") instanceof Map)) continue;
                Map mapValue = (Map)result.get("value");
                valueForKey.add(mapValue.get("name").toString());
            }
        }
        catch (Exception e) {
            LOG.error("Error processing JSON: " + e.getMessage(), (Throwable)e);
        }
        return valueForKey;
    }

    private static Map<String, Object> convertToGenericStructure(JsonNode jsonNode) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (jsonNode.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> fields = jsonNode.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field = fields.next();
                String key = field.getKey();
                JsonNode value = field.getValue();
                if (value.isObject()) {
                    result.put(key, JSONUtil.convertToGenericStructure(value));
                    continue;
                }
                if (value.isArray()) {
                    result.put(key, JSONUtil.convertArrayToGenericStructure(value));
                    continue;
                }
                result.put(key, JSONUtil.convertValueNode(value));
            }
        }
        return result;
    }

    private static List<Object> convertArrayToGenericStructure(JsonNode arrayNode) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonNode element : arrayNode) {
            if (element.isObject()) {
                result.add(JSONUtil.convertToGenericStructure(element));
                continue;
            }
            if (element.isArray()) {
                result.add(JSONUtil.convertArrayToGenericStructure(element));
                continue;
            }
            result.add(JSONUtil.convertValueNode(element));
        }
        return result;
    }

    private static Object convertValueNode(JsonNode valueNode) {
        if (valueNode.isTextual()) {
            return valueNode.asText();
        }
        if (valueNode.isNumber()) {
            return valueNode.numberValue();
        }
        if (valueNode.isBoolean()) {
            return valueNode.asBoolean();
        }
        if (valueNode.isNull()) {
            return null;
        }
        return valueNode.toString();
    }

    public static List<Map<String, Object>> searchForKey(Map<String, Object> structure, String targetKey) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        JSONUtil.searchForKeyRecursive(structure, targetKey, "", results);
        return results;
    }

    private static void searchForKeyRecursive(Map<String, Object> structure, String targetKey, String currentPath, List<Map<String, Object>> results) {
        for (Map.Entry<String, Object> entry : structure.entrySet()) {
            String newPath;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = newPath = currentPath.isEmpty() ? key : currentPath + "." + key;
            if (key.toLowerCase().contains(targetKey.toLowerCase())) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("path", newPath);
                result.put("name", key);
                result.put("value", value);
                result.put("type", value.getClass().getSimpleName());
                results.add(result);
            }
            if (value instanceof Map) {
                JSONUtil.searchForKeyRecursive((Map)value, targetKey, newPath, results);
                continue;
            }
            if (!(value instanceof List)) continue;
            JSONUtil.searchInList((List)value, targetKey, newPath, results);
        }
    }

    private static void searchInList(List<Object> list, String targetKey, String currentPath, List<Map<String, Object>> results) {
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            String listPath = currentPath + "[" + i + "]";
            if (item instanceof Map) {
                JSONUtil.searchForKeyRecursive((Map)item, targetKey, listPath, results);
                continue;
            }
            if (!(item instanceof List)) continue;
            JSONUtil.searchInList((List)item, targetKey, listPath, results);
        }
    }

    private static void printStructure(Map<String, Object> structure, int depth) {
        String indent = "  ".repeat(depth);
        for (Map.Entry<String, Object> entry : structure.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            LOG.debug(indent + key + ": ");
            if (value instanceof Map) {
                LOG.debug("\n{");
                JSONUtil.printStructure((Map)value, depth + 1);
                LOG.debug("\n " + indent + "}");
                continue;
            }
            if (value instanceof List) {
                LOG.debug("\n [");
                JSONUtil.printList((List)value, depth + 1);
                LOG.debug("\n " + indent + "]");
                continue;
            }
            LOG.debug("\n " + value);
        }
    }

    private static void printList(List<Object> list, int depth) {
        String indent = "  ".repeat(depth);
        for (Object item : list) {
            LOG.debug(indent);
            if (item instanceof Map) {
                LOG.debug("\n {");
                JSONUtil.printStructure((Map)item, depth + 1);
                LOG.debug("\n " + indent + "}");
                continue;
            }
            if (item instanceof List) {
                LOG.debug("\n [");
                JSONUtil.printList((List)item, depth + 1);
                LOG.debug("\n " + indent + "]");
                continue;
            }
            LOG.debug("\n " + item);
        }
    }
}

