/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.config;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DAO {
    private static final Logger LOG = LoggerFactory.getLogger(DAO.class);
    private static final String PLUGIN_STORAGE_KEY = "de.accxia.apps.confluence.LogViewer";
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    @ComponentImport
    private final BootstrapManager bootstrapManager;
    private PluginSettings globalPluginSettings = null;

    @Inject
    public DAO(PluginSettingsFactory pluginSettingsFactory, BootstrapManager bootstrapManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.bootstrapManager = bootstrapManager;
    }

    public String getValue(String field) {
        PluginSettings pluginSettings = this.getPluginSettings();
        Object value = pluginSettings.get("de.accxia.apps.confluence.LogViewer." + field);
        if (value == null || "null".equals(value)) {
            value = "";
            pluginSettings.put("de.accxia.apps.confluence.LogViewer." + field, (Object)"");
        }
        String res = String.valueOf(value);
        return res;
    }

    public void setValue(String field, String value) {
        PluginSettings pluginSettings = this.getPluginSettings();
        pluginSettings.put("de.accxia.apps.confluence.LogViewer." + field, (Object)value);
    }

    public void updateLogDir(String value) {
        this.setValue("logDir", value);
    }

    public String getLogDir() {
        String res = this.getValue("logDir");
        return res == null || "".equals(res) ? this.bootstrapManager.getLocalHome().getPath() : res;
    }

    public void updateRegEx(String value) {
        this.setValue("regEx", value);
    }

    public String getRegEx() {
        String res = this.getValue("regEx");
        return res == null || "".equals(res) ? "" : res;
    }

    public String getRegEx(String def) {
        String res = this.getValue("regEx");
        return res == null || "".equals(res) ? def : res;
    }

    public void updateFileFilter(String value) {
        this.setValue("fileFilter", value);
    }

    public String getFileFilter() {
        String res = this.getValue("fileFilter");
        return StringUtils.isEmpty((CharSequence)res) ? "*" : res;
    }

    private PluginSettings getPluginSettings() {
        if (this.globalPluginSettings == null) {
            this.globalPluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        }
        return this.globalPluginSettings;
    }
}

