/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.log;

import de.accxia.apps.confluence.logViewer.log.LogStat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class FilterLogStats {
    public static final Comparator<LogStat> CMP_LS_60 = new Comparator<LogStat>(){

        private boolean compareTimes(String time1, String time2) {
            if (time1 == null && time2 == null) {
                return true;
            }
            if (time1 == null || time2 == null) {
                return false;
            }
            int index1 = time1.indexOf(":");
            int index2 = time2.indexOf(":");
            if (index1 == -1 || index2 == -1) {
                return false;
            }
            String hour1 = time1.substring(0, index1);
            String hour2 = time2.substring(0, index2);
            return Objects.equals(hour1, hour2);
        }

        @Override
        public int compare(LogStat ls1, LogStat ls2) {
            if (ls1 == ls2) {
                return 0;
            }
            if (ls1 == null) {
                return -1;
            }
            if (ls2 == null) {
                return 1;
            }
            return ls1.confluenceRole == ls2.confluenceRole && Objects.equals(ls1.user, ls2.user) && this.compareTimes(ls1.time, ls2.time) && Objects.equals(ls1.date, ls2.date) ? 0 : 1;
        }
    };
    private Set<LogStat> filterlogStatatistics;

    public FilterLogStats(Comparator<LogStat> comparator) {
        this.filterlogStatatistics = new TreeSet<LogStat>(comparator);
    }

    public Set<LogStat> getFilterlogStatatistics() {
        return this.filterlogStatatistics;
    }

    public void addAll(Collection<LogStat> logStats) {
        this.filterlogStatatistics.addAll(logStats);
    }

    public void add(LogStat logStat) {
        this.filterlogStatatistics.add(logStat);
    }
}

