/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.log;

import java.util.Objects;

public class LogStat {
    public String user;
    public String time;
    public String date;
    public String path;
    public boolean confluenceRole;
    public boolean iumRole;

    public LogStat(String user, String date, String time, String path) {
        this.user = user;
        this.date = date;
        this.time = time;
        this.path = path;
    }

    public LogStat(String user, String date, String time, String path, boolean confluenceRole, boolean iumRole) {
        this(user, date, time, path);
        this.confluenceRole = confluenceRole;
        this.iumRole = iumRole;
    }

    public String getUser() {
        return this.user;
    }

    public String getTime() {
        return this.time;
    }

    public String getShortTime() {
        if (this.time == null || this.time.length() == 0) {
            return "";
        }
        int index = this.time.indexOf(":");
        if (index == -1) {
            return this.time;
        }
        return this.time.substring(0, index);
    }

    public String getDate() {
        return this.date;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isConfluenceRole() {
        return this.confluenceRole;
    }

    public void setConfluenceRole(boolean confluenceRole) {
        this.confluenceRole = confluenceRole;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogStat logStat = (LogStat)o;
        return this.confluenceRole == logStat.confluenceRole && Objects.equals(this.user, logStat.user) && Objects.equals(this.getShortTime(), logStat.getShortTime()) && Objects.equals(this.date, logStat.date);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.user);
        result = 31 * result + Objects.hashCode(this.getShortTime());
        result = 31 * result + Objects.hashCode(this.date);
        result = 31 * result + Boolean.hashCode(this.confluenceRole);
        return result;
    }

    public String toString() {
        return "LogStat{user='" + this.user + "', time='" + this.time + "', date='" + this.date + "', path='" + this.path + "', confluenceRole=" + this.confluenceRole + "}";
    }
}

