/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.servlet;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.confluence.logViewer.config.DAO;
import de.accxia.apps.confluence.logViewer.servlet.BaseHttpServlet;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MainViewer
extends BaseHttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MainViewer.class);
    private static final long serialVersionUID = -3867346254658694520L;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final BootstrapManager bootstrapManager;
    @ComponentImport
    private final SettingsManager settingsManager;
    private final DAO dao;
    private static List<String> listOfRegex = Arrays.asList("^\\S+\\s(?<name>\\S+)\\s\\[(?<date>\\d{2}/\\w{3}/\\d{4}):(?<time>\\d{2}:\\d{2}:\\d{2})(?:\\s[+\\-]\\d{4})\\]\\s\"[A-Z]+\\s(?<path>\\S+).*$", "^\\[(?<date>\\d{2}/\\w{3}/\\d{4}):(?<time>\\d{2}:\\d{2}:\\d{2})(?:\\s[+\\-]\\d{4})\\]\\s*(?<name>\\S+)\\s*(?:\\S+)\\s*(?:\\S+)\\s*(?:\\S+)\\s*(?<path>\\S+).*$");
    private static String regExDef = listOfRegex.get(0);

    @Inject
    public MainViewer(WebSudoManager webSudoManager, UserManager userManager, TemplateRenderer renderer, BootstrapManager bootstrapManager, SettingsManager settingsManager, DAO dao) {
        super(bootstrapManager, dao);
        this.webSudoManager = webSudoManager;
        this.userManager = userManager;
        this.renderer = renderer;
        this.bootstrapManager = bootstrapManager;
        this.settingsManager = settingsManager;
        this.dao = dao;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        try {
            String logPath;
            this.webSudoManager.willExecuteWebSudoRequest(req);
            UserProfile user = this.userManager.getRemoteUser(req);
            if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
                throw new WebSudoSessionException();
            }
            String action = req.getParameter("action");
            if ("goto".equals(action) && (logPath = req.getParameter("logDir")) != null && !logPath.startsWith(".")) {
                this.dao.updateLogDir(logPath);
            }
            if ("parent".equals(action)) {
                String currentPath = this.dao.getLogDir();
                File file = new File(currentPath);
                this.dao.updateLogDir(file.getParent());
            }
            this.renderMainVM(req, resp);
        }
        catch (WebSudoSessionException wes) {
            log.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        try {
            String logPath;
            this.webSudoManager.willExecuteWebSudoRequest(req);
            UserProfile user = this.userManager.getRemoteUser(req);
            if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
                throw new WebSudoSessionException();
            }
            String myPar = req.getParameter("action");
            if ("goto".equals(myPar) && (logPath = req.getParameter("logDir")) != null && !logPath.startsWith(".")) {
                this.dao.updateLogDir(logPath);
            }
            if ("Save Settings".equals(myPar)) {
                String regEx;
                logPath = req.getParameter("logDir");
                if (logPath != null && !logPath.startsWith(".")) {
                    this.dao.updateLogDir(logPath);
                }
                if ((regEx = req.getParameter("regEx")) != null && !"".equals(regEx)) {
                    this.dao.updateRegEx(regEx);
                }
            }
            if ("Filter".equalsIgnoreCase(myPar)) {
                String fileFilter = req.getParameter("fileFilter");
                this.dao.updateFileFilter(fileFilter);
            }
            this.renderMainVM(req, resp);
        }
        catch (WebSudoSessionException wes) {
            log.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }

    public static String getConfluenceInstallPath() {
        try {
            String path = BootstrapManager.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            File classesDir = new File(decodedPath);
            File webInfDir = classesDir.getParentFile();
            File confluenceDir = webInfDir.getParentFile();
            File installDir = confluenceDir.getParentFile();
            if (installDir != null) {
                installDir = installDir.getParentFile();
            }
            return installDir.getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void renderMainVM(HttpServletRequest req, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        response.setContentType("text/html;charset=utf-8");
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String backupPath = this.settingsManager.getGlobalSettings().getBackupPath();
        context.put("baseUrl", baseUrl);
        context.put("tomcatHome", MainViewer.getConfluenceInstallPath());
        context.put("confluenceHome", this.bootstrapManager.getConfluenceHome());
        context.put("applicationHome", this.bootstrapManager.getApplicationHome());
        context.put("hibernateDialect", this.bootstrapManager.getHibernateDialect());
        List<Map<String, String>> fileInfos = this.listLogs(this.dao.getFileFilter());
        context.put("fileInfos", fileInfos);
        context.put("listOfRegex", listOfRegex);
        context.put("logDir", this.dao.getLogDir());
        context.put("regEx", this.dao.getRegEx(regExDef));
        context.put("fileFilter", this.dao.getFileFilter());
        this.renderer.render("templates/logviewer-main.vm", context, (Writer)response.getWriter());
    }
}

