var askVerifyStatus = null;

function downloadFileFromURL(url, defaultFileName) {
    let fileName = defaultFileName;

    fetch(url).then(response => {
        if (!response.ok) throw new Error('Network response was not ok');


        // Get filename from Content-Disposition header
        const contentDisposition = response.headers.get('Content-Disposition');

        if (contentDisposition) {
            const fileNameMatch = contentDisposition.match(/filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/);

            if (fileNameMatch && fileNameMatch[1]) {
                // Remove quotes if present
                fileName = fileNameMatch[1].replace(/['"]/g, '');

                // Handle UTF-8 filenames (RFC 5987)
                if (fileName.startsWith("UTF-8''")) {
                    fileName = decodeURIComponent(fileName.replace("UTF-8''", ''));
                }
            }
        }


        return response.blob();
    }).then(blob => {
        // Create download link
        const url = window.URL.createObjectURL(blob);
        const link = document.createElement('a');
        link.href = url;
        link.download = fileName;

        // Trigger download
        document.body.appendChild(link);
        link.click();

        // Clean up
        window.URL.revokeObjectURL(url);
        document.body.removeChild(link);
    }).catch(error => {
        console.error('Download failed:', error);
        alert('Download failed. Please try again.');
    })

}

// Path     : "/plugins/servlet/logviewer?action=downloadResults&type=all"
// fileName : "results.csv")
function downloadResults() {
    let url = AJS.contextPath() + "/plugins/servlet/logviewer?action=downloadResults&type=all";
    let fileName = "results.csv";
    downloadFileFromURL(url, fileName);
    return;
}

// Path     : "/plugins/servlet/logviewer?action=downloadResults&type=all"
// fileName : "results.csv")
function downloadJSMResults() {
    let url = AJS.contextPath() + "/plugins/servlet/logviewer?action=downloadResults&type=jsm";
    let fileName = "results.csv";
    downloadFileFromURL(url, fileName);
    return;
}


// Path     : "/plugins/servlet/logviewer?action=downloadResults&type=all"
// fileName : "results.csv")
function downloadConfluenceResults() {
    let url = AJS.contextPath() + "/plugins/servlet/logviewer?action=downloadResults&type=confluence";
    let fileName = "results.csv";
    downloadFileFromURL(url, fileName);
    return;
}

function resetElements(evt){
    document.getElementById("nodes").style.display = 'inline';
    document.getElementById("nodes").innerHTML = `0/0`
    askVerifyStatus=false;

    return true;
}

function resetFormElements(evt){
    document.getElementById("nodes").style.display = 'inline';
    document.getElementById("nodes").innerHTML = `0/0`
    askVerifyStatus=true;
    setTimeout(verifyStatus,1000);
    return true;
}

function verifyStatus() {
    let url = AJS.contextPath() + "/rest/logger/latest/status/nodes";
    if(!askVerifyStatus){
        return
    }

    fetch(url).then(response => {
        if (response.ok) {
            return response.json();
        } else {
            throw new Error('Network response was not ok');
        }
    })
    .then(data =>{
        //console.log(data)
        //debugger
        document.getElementById("nodes").innerHTML = `${data.completed}/${data.nodes}`

        let html = "";
        if(data.results){
            // console.log(data.results)

            for (const [key, value] of Object.entries(data.results)) {
                html +=`<div>Logs from ${key}  have been added! (row matched= ${value})</div>`;
            }
            if(!!document.getElementById("results").contentDocument.body){
                document.getElementById("results").contentDocument.body.innerHTML=html;
            }else{
                document.getElementById("results").contentDocument.write(html);
            }
        }


        if (data.nodes === data.completed) {
            askVerifyStatus = false;
           // document.getElementById("nodes").style.display = 'none'
        } else {
            setTimeout(verifyStatus,5000);
        }
    }).catch(error => console.error('There was a problem with the fetch operation:', error));

}

