/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FileInfo
implements Serializable {
    String name;
    String absolutePath;
    long length;
    boolean isFile;

    public FileInfo() {
    }

    public FileInfo(File file) {
        this.name = file.getName();
        this.absolutePath = file.getAbsolutePath();
        this.length = file.length();
        this.isFile = file.isFile();
    }

    public static Map<String, String> toMap(final File file) {
        HashMap<String, String> retVal = new HashMap<String, String>(){
            {
                this.put("name", file.getName());
                this.put("absolutePath", file.getAbsolutePath());
                this.put("length", String.valueOf(file.isFile() ? file.length() / 1024L / 1024L : 0L));
                this.put("isFile", Boolean.toString(file.isFile()));
                this.put("key2", "value2");
            }
        };
        return retVal;
    }

    public static List<Map<String, String>> toFileInfos(File[] files) {
        if (files == null) {
            return null;
        }
        List<Map<String, String>> retVal = Arrays.stream(files).map(FileInfo::toMap).collect(Collectors.toList());
        return retVal;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void setFile(boolean file) {
        this.isFile = file;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public String toString() {
        return "FileInfo{name='" + this.name + "', absolutePath='" + this.absolutePath + "', length=" + this.length + ", isFile=" + this.isFile + "}";
    }
}

