/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.servlet;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import de.accxia.apps.confluence.logViewer.config.DAO;
import de.accxia.apps.confluence.logViewer.log.FilterLogStats;
import de.accxia.apps.confluence.logViewer.log.LogStat;
import de.accxia.apps.confluence.logViewer.log.LogStats;
import de.accxia.apps.confluence.logViewer.log.ProcessingResults;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogsAnalyser {
    private static final Logger LOG = LoggerFactory.getLogger(LogsAnalyser.class);
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private final ConfluenceAccessManager confluenceAccessManager;
    @ComponentImport
    private final UserManager userManage;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final DAO dao;

    @Inject
    public LogsAnalyser(PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, ConfluenceAccessManager confluenceAccessManager, UserManager userManage, UserAccessor userAccessor, DAO dao) {
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.confluenceAccessManager = confluenceAccessManager;
        this.userManage = userManage;
        this.userAccessor = userAccessor;
        this.dao = dao;
    }

    @Deprecated
    private LogStats analyseLogs(HttpServletRequest req, HttpServletResponse resp, String[] names) {
        FilterLogStats filterLogStats = new FilterLogStats(FilterLogStats.CMP_LS_60);
        LogStats ls = new LogStats();
        if (names == null || names.length == 0) {
            return ls;
        }
        HashMap<String, UserRole> cacheUserRoles = new HashMap<String, UserRole>();
        try {
            resp.setContentType("text/html");
            resp.getWriter().write("<html><body>");
            for (String name : names) {
                try {
                    FilterLogStats tmp = this.extractLog(cacheUserRoles, name);
                    resp.getWriter().write("<div>Logs from " + name + " have been added! (row matched=" + tmp.getFilterlogStatatistics().size() + ")</div>");
                    filterLogStats.addAll(tmp.getFilterlogStatatistics());
                    tmp = null;
                }
                catch (IOException e) {
                    resp.getWriter().write("Exception " + name + "  " + e.getMessage());
                }
            }
            resp.getWriter().write("</body></html>");
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            try {
                resp.getWriter().write("Error: " + e.getMessage());
            }
            catch (IOException e1) {
                LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            }
        }
        ls.logStats.addAll(filterLogStats.getFilterlogStatatistics());
        return ls;
    }

    public boolean hasUserConfluenceAccess(ConfluenceUser confluenceUser) {
        return this.permissionManager.hasPermission((User)confluenceUser, Permission.VIEW, Space.class);
    }

    public FilterLogStats extractLog(Map<String, UserRole> cacheUserRoles, String name) throws IOException {
        FilterLogStats ls = new FilterLogStats(FilterLogStats.CMP_LS_60);
        if (name == null || name.length() == 0) {
            return ls;
        }
        String regEx = this.dao.getRegEx();
        Pattern pattern = Pattern.compile(regEx, 32);
        try (FileInputStream fstream = new FileInputStream(name);
             BufferedReader br = new BufferedReader(new InputStreamReader(fstream));){
            String strLine;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsing filename=" + name);
            }
            int lineCount = 0;
            while ((strLine = br.readLine()) != null) {
                ++lineCount;
                try {
                    Matcher matcher = pattern.matcher(strLine);
                    if (matcher.matches() && matcher.groupCount() >= 3 && matcher.group("date") != null && matcher.group("time") != null && matcher.group("name") != null) {
                        String path;
                        String string = matcher.group("name");
                        if ("-".equals(string)) continue;
                        if (!cacheUserRoles.containsKey(string)) {
                            ConfluenceUser applicationUser = this.userAccessor.getUserByName(string);
                            if (applicationUser != null) {
                                UserRole userRole = new UserRole(this.confluenceAccessManager.getUserAccessStatusNoExemptions((User)applicationUser).canUseConfluence(), false);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("User " + string + " has roles: " + userRole.confluenceRole);
                                }
                                cacheUserRoles.put(string, userRole);
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("User " + string + " not found  ");
                                }
                                cacheUserRoles.put(string, new UserRole(false, false));
                            }
                        }
                        String date = matcher.group("date");
                        String time = matcher.group("time");
                        String string2 = path = matcher.groupCount() >= 4 && matcher.group("path") != null ? matcher.group("path") : "";
                        if (cacheUserRoles.containsKey(string)) {
                            UserRole userRole = cacheUserRoles.get(string);
                            ls.add(new LogStat(string, date, time, path, userRole.confluenceRole, userRole.iumRole));
                        } else {
                            ls.add(new LogStat(string, date, time, path));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception parse  " + e.getMessage(), (Throwable)e);
                }
                if (lineCount % 100 != 0) continue;
                ProcessingResults.getInstance().addResult(name, ls.getFilterlogStatatistics().size());
            }
            if (LOG.isTraceEnabled()) {
                for (LogStat logStat : ls.getFilterlogStatatistics()) {
                    LOG.trace(logStat.date + "," + logStat.time + "," + logStat.path + "," + logStat.user);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception parse  " + e.getMessage(), (Throwable)e);
        }
        return ls;
    }

    public LogStats extractLogs(String[] names) {
        LogStats ls = new LogStats();
        HashMap<String, UserRole> cacheUserRoles = new HashMap<String, UserRole>();
        if (names == null || names.length == 0) {
            return ls;
        }
        for (String name : names) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parse filename=" + name);
                }
                ProcessingResults.getInstance().addResult(name, 0);
                FilterLogStats tmp = this.extractLog(cacheUserRoles, name);
                ProcessingResults.getInstance().addResult(name, tmp.getFilterlogStatatistics().size());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parsed filename=" + name);
                }
                if (LOG.isTraceEnabled()) {
                    for (LogStat user : tmp.getFilterlogStatatistics()) {
                        LOG.trace(user.date + "," + user.time + "," + user.path + "," + user.user);
                    }
                }
                ls.logStats.addAll(tmp.getFilterlogStatatistics());
                tmp = null;
            }
            catch (Exception e) {
                LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            }
        }
        return ls;
    }

    public boolean saveOnDisk(File csvFile, LogStats ls) {
        PrintWriter pw = new PrintWriter(csvFile);
        try {
            pw.write("date,time,user,conf\n");
            for (LogStat user : ls.logStats) {
                pw.write(user.date + "," + user.time + "," + user.user + "," + user.confluenceRole + "\n");
            }
            boolean bl = true;
            pw.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Exception:" + e.getMessage(), (Throwable)e);
                return false;
            }
        }
    }

    public void concatenateFiles(String[] inputFilePaths, String outputFilePath) throws IOException {
        boolean wroteHeader = false;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));){
            for (String inputFilePath : inputFilePaths) {
                try (BufferedReader reader = new BufferedReader(new FileReader(inputFilePath));){
                    String line = reader.readLine();
                    if (!wroteHeader && line != null) {
                        writer.write(line);
                        writer.newLine();
                        wroteHeader = true;
                    }
                    while ((line = reader.readLine()) != null) {
                        writer.write(line);
                        writer.newLine();
                    }
                }
            }
        }
    }

    public LogStats loadFromCSV(File csvFile) {
        LogStats ls = new LogStats();
        try (BufferedReader reader = new BufferedReader(new FileReader(csvFile));){
            String line;
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                if (parts.length < 3) continue;
                String date = parts[0];
                String time = parts[1];
                String user = parts[2];
                String jira = parts.length >= 4 ? parts[3] : "false";
                String jsm = parts.length >= 5 ? parts[4] : "false";
                LogStat logStat = new LogStat(user, date, time, "", Boolean.parseBoolean(jira), Boolean.parseBoolean(jsm));
                ls.logStats.add(logStat);
            }
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            for (LogStat logStat : ls.logStats) {
                LOG.trace("LogStat: " + logStat.user + " " + logStat.date + " " + logStat.time);
            }
        }
        return ls;
    }

    private class UserRole {
        private boolean confluenceRole;
        private boolean iumRole;

        public UserRole(boolean confluenceRole) {
            this(confluenceRole, false);
        }

        public UserRole(boolean confluenceRole, boolean iumRole) {
            this.confluenceRole = confluenceRole;
            this.iumRole = iumRole;
        }

        public boolean isConfluenceRole() {
            return this.confluenceRole;
        }

        public void setConfluenceRole(boolean confluenceRole) {
            this.confluenceRole = confluenceRole;
        }

        public boolean isIumRole() {
            return this.iumRole;
        }

        public void setIumRole(boolean iumRole) {
            this.iumRole = iumRole;
        }
    }
}

