//Should be declarated as var to allow  main calling

var IUMCharts= {
    backgroundColors : [
        'rgba(54, 162, 235, 0.6)',      // (Blue)
        'rgba(255, 99, 132, 0.6)',      // (Red)
        'rgba(75, 192, 192, 0.6)',      // (Teal)
        'rgba(255, 159, 64, 0.6)',      // (Orange)
        'rgba(153, 102, 255, 0.6)',     // (Purple)
        'rgba(255, 205, 86, 0.6)',      // (Yellow)
        'rgba(101, 203, 103, 0.6)',     // (Green)
        'rgba(201, 203, 207, 0.6)',     // (Gray)
        'rgba(239, 71, 111, 0.6)',      // (Pink)
        'rgba(6, 214, 160, 0.6)',       // (Turquoise)
        'rgba(247, 143, 179, 0.6)',     // (Light Pink)
        'rgba(102, 204, 255, 0.6)',     //  (Sky Blue)
        'rgba(179, 136, 255, 0.6)',     //  (Lavender)
        'rgba(255, 179, 102, 0.6)',     //  (Peach)
        'rgba(0, 179, 164, 0.6)',       //  (Mint)
        'rgba(255, 102, 102, 0.6)',     //  (Coral)
        'rgba(204, 153, 255, 0.6)',     //  (Light Purple)
        'rgba(255, 209, 102, 0.6)',     //  (Gold)
        'rgba(77, 208, 225, 0.6)',      //  (Aqua)
        'rgba(255, 133, 82, 0.6)',      //  (Tangerine)
        'rgba(160, 212, 104, 0.6)',     //  (Light Green)
        'rgba(148, 93, 214, 0.6)',      //  (Deep Purple)
        'rgba(255, 87, 34, 0.6)',       //  (Deep Orange)
        'rgba(0, 150, 136, 0.6)'        // (Teal Dark)
    ],

    darkBackgroundColors : [
        'rgba(54, 162, 235, 1.0)',      // (Blue)
        'rgba(255, 99, 132, 1.0)',      // (Red)
        'rgba(75, 192, 192, 1.0)',      // (Teal)
        'rgba(255, 159, 64, 1.0)',      // (Orange)
        'rgba(153, 102, 255, 1.0)',     // (Purple)
        'rgba(255, 205, 86, 1.0)',      // (Yellow)
        'rgba(101, 203, 103, 1.0)',     // (Green)
        'rgba(201, 203, 207, 1.0)',     // (Gray)
        'rgba(239, 71, 111, 1.0)',      // (Pink)
        'rgba(6, 214, 1.0, 1.0)',       // (Turquoise)
        'rgba(247, 143, 179, 1.0)',     // (Light Pink)
        'rgba(102, 204, 255, 1.0)',     //  (Sky Blue)
        'rgba(179, 136, 255, 1.0)',     //  (Lavender)
        'rgba(255, 179, 102, 1.0)',     //  (Peach)
        'rgba(0, 179, 164, 1.0)',       //  (Mint)
        'rgba(255, 102, 102, 1.0)',     //  (Coral)
        'rgba(204, 153, 255, 1.0)',     //  (Light Purple)
        'rgba(255, 209, 102, 1.0)',     //  (Gold)
        'rgba(77, 208, 225, 1.0)',      //  (Aqua)
        'rgba(255, 133, 82, 1.0)',      //  (Tangerine)
        'rgba(1.0, 212, 104, 1.0)',     //  (Light Green)
        'rgba(148, 93, 214, 1.0)',      //  (Deep Purple)
        'rgba(255, 87, 34, 1.0)',       //  (Deep Orange)
        'rgba(0, 1.0, 136, 1.0)'        // (Teal Dark)
    ],

    //Chart.register(ChartDataLabels);
    accxiaChart:null,

    loadData :async function() {

        let type =  document.querySelector('meta[name="chart-app"]')?.content;
        let url = AJS.contextPath() + "/rest/logger/latest/charts?type=" + type;

        const ctx = document.getElementById('userChart').getContext('2d');

        // debugger
        const response = await fetch(url);
        const json = await response.json();
        const hours = Array.from({length: 24}, (_, i) =>
            i.toString().padStart(2, '0')
        );
        // const hours = Array.from({length: 24}, (_, i) => `${i}:00`);


        if (!IUMCharts.accxiaChart) {
            IUMCharts.accxiaChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: hours,
                    datasets: [{
                        label: 'Users per hour',
                        data: Array(24).fill(0),
                        backgroundColor: 'rgba(75, 192, 192, 0.6)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        x: { stacked: true,title: { display: true, text: 'Hour of Day' } },
                        y: { stacked: true,
                            beginAtZero: true,
                            title: {display: true, text: 'Number of Users' },
                            ticks: { precision: 0 }
                        }
                    },
                    legend: {
                        display: false
                    },
                    plugins: {
                        legend: {
                            position: 'right',
                            labels: {
                                usePointStyle: true,
                                pointStyle: 'rectRounded',
                                padding: 20,
                                font: { size: 12 },
                                filter: function(item, chart) {
                                    // Logic to remove a particular legend item goes here
                                    return item && chart.datasets[item.datasetIndex] && chart.datasets[item.datasetIndex].label;
                                },
                            },
                        },
                        tooltip: {
                                callbacks: {
                                    label: function(context) {
                                        return `${context.dataset.msg}: ${context.raw}`;
                                    }
                                }
                            }

                    }
                }
            });
        }
        // Update chart data
        // Transform json.data for Chart.js
        var ID = 0;
        const datasets=[];

        Object.entries(json.data).map(([date, hours]) => ({
            msg:  json.bothAccess,
            label: date,
            data: Array.from({length: 24}, (_, hour) => hours[hour] ? hours[hour].role1Count  :  0),
            backgroundColor:IUMCharts.backgroundColors[ID],
            stack: 'Stack '+(ID++)

        })).forEach(item=>datasets.push(item));
        /*
        ID=0;
        Object.entries(json.data).map(([date, hours]) => ({
            msg:  json.onlyAccess,
            data: Array.from({length: 24}, (_, hour) => hours[hour] ? hours[hour].role2Count  :  0),
            backgroundColor:IUMCharts.darkBackgroundColors[ID],
            stack: 'Stack '+(ID++)
        })).forEach(item=>datasets.push(item));
        */

        // debugger
        for(let id=0;id<24;id++){
            if(datasets[id]) {
                    IUMCharts.accxiaChart.data.datasets[id]={
                        msg:datasets[id].msg,
                        label:datasets[id].label,
                        data: datasets[id].data,
                        stack: datasets[id].stack,
                        backgroundColor: datasets[id].backgroundColor,
                        borderColor:  datasets[id].backgroundColor,
                        borderWidth: 1
                    }
                }
        }


        IUMCharts.accxiaChart.update();
    },

    downloadPDF: async function() {
        const { jsPDF } = window.jspdf;
        const pdf = new jsPDF({
            orientation: 'landscape',
            unit: 'pt',
            format: 'a4'
        });

        const pageWidth = pdf.internal.pageSize.getWidth();
        const pageHeight = pdf.internal.pageSize.getHeight();

        const title = document.getElementById("chart-title").innerHTML;
        const type =  document.querySelector('meta[name="chart-app"]')?.content;
        const lightLegend = document.getElementById("light-legend").innerText;
        // const darkLegend = document.getElementById("dark-legend").innerText;


        // Set font and size
        pdf.setFontSize(24);
        pdf.setFont('helvetica', 'bold');

        // Center title horizontally
        const titleWidth = pdf.getTextWidth(title);
        const tx = (pageWidth - titleWidth) / 2;
        const ty = 40;

        pdf.text(title, tx, ty);

        const canvas = document.getElementById('userChart');
        const imageData = canvas.toDataURL('image/png', 1.0);

        // Add chart image
        // Maintain aspect ratio
        const imgProps = {
            width: canvas.width,
            height: canvas.height
        };
        const ratio = imgProps.height / imgProps.width;
        const imgWidth = pageWidth;
        const imgHeight = imgWidth * ratio;

        // Center vertically (optional)
        const y = (pageHeight - imgHeight) / 2;

        pdf.addImage(imageData, 'PNG', 0, y, imgWidth, imgHeight);

        const imageY = 20;
        const finalY = imageY + imgHeight + 30; // Position after image

        // Add custom text at the end
        // const customText = `${lightLegend}   ||   ${darkLegend}`;
        // pdf.setFontSize(12);
        // pdf.setTextColor(150);
        // pdf.text(customText, 20, pageHeight - 20); // Stay within page

        /*
        // Add watermark (diagonal, semi-transparent)
        pdf.setTextColor(150, 150, 150); // light gray
        pdf.setFontSize(40);
        pdf.setFont("helvetica", "bold");
        pdf.setTextColor(150, 150, 150, 0.2); // optional transparency in RGB format (opacity simulated)

        // Rotate and place watermark text
        pdf.saveGraphicsState();
        pdf.setGState(new pdf.GState({ opacity: 0.1 }));
        pdf.text("IUM analyzer for Accxia ", 150, 450, { angle: 45 });
        pdf.restoreGraphicsState();
        */

        // Save file
        pdf.save(`user-activity-chart-${type}.pdf`);
    },

    refreshData: function () {
        IUMCharts.loadData();
     },

    /*
    getRandomColor: function () {
        var letters = '0123456789ABCDEF';
        var color = '#';
        for (var i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    },
    */
}