/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.listener;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import de.accxia.apps.confluence.logViewer.config.DAO;
import de.accxia.apps.confluence.logViewer.log.LogStats;
import de.accxia.apps.confluence.logViewer.log.ProcessingResults;
import de.accxia.apps.confluence.logViewer.servlet.LogsAnalyser;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@ExportAsService(value={IUMClusterAnalyzer.class})
@Named(value="IUMClusterAnalyzer")
public class IUMClusterAnalyzer
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(IUMClusterAnalyzer.class);
    private static final String PSEUDO_NODENAME = "Node" + System.currentTimeMillis();
    private static final String ANALYZE_CHANNEL = "analyze-channel3";
    public static final String FILE_PREFIX = "FILE:";
    public static final String ANALYZE_RESPONSE = "RESPONSE:";
    public static final String ANALYZE_ERROR = "ERROR:";
    public static final String SYNC_KEY = "CACHE_KEY";
    public static final String SYNC_VALUE = "CACHE_VALUE";
    public static final String SYNC_FILES = "SYNC_FILES";
    public static final String SYNC_COMBINE_FILES = "SYNC_COMBINE_FILES";
    public static final String SYNC_RESULT = "results.csv";
    @ComponentImport
    private final ClusterManager clusterManager;
    @ComponentImport
    private final BootstrapManager bootstrapManager;
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    private final LogsAnalyser logsAnalyser;
    private final ExecutorService executorService;
    private final DAO dao;
    private File sharedCachesDirectory;
    private String nodeName = "";
    private static final int maxRetries = 50;
    private static final long delayMillis = 200L;

    @Inject
    public IUMClusterAnalyzer(ClusterManager clusterManager, BootstrapManager bootstrapManager, EventPublisher eventPublisher, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, LogsAnalyser logsAnalyser, DAO dao) {
        this.clusterManager = clusterManager;
        this.bootstrapManager = bootstrapManager;
        this.eventPublisher = eventPublisher;
        this.dao = dao;
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
        ExecutorService raw = Executors.newFixedThreadPool(4);
        this.executorService = threadLocalDelegateExecutorFactory.createExecutorService(raw);
        this.logsAnalyser = logsAnalyser;
        try {
            if (this.clusterManager.isClustered()) {
                this.sharedCachesDirectory = new File(bootstrapManager.getSharedHome(), "logViewer");
                if (!this.sharedCachesDirectory.exists()) {
                    this.sharedCachesDirectory.mkdirs();
                }
                this.nodeName = clusterManager.getThisNodeInformation().getAnonymizedNodeIdentifier();
            } else {
                this.sharedCachesDirectory = new File(bootstrapManager.getConfluenceHome(), "logViewer");
                if (!this.sharedCachesDirectory.exists()) {
                    this.sharedCachesDirectory.mkdirs();
                }
            }
            LOG.info("IUMClusterAnalyzer " + this.sharedCachesDirectory.getAbsoluteFile());
        }
        catch (Exception e) {
            LOG.error("Exception IUMClusterAnalyzer " + e.getMessage(), (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        this.executorService.shutdown();
        ProcessingResults.getInstance().clearResult();
    }

    private void sendRemote(String channel, String message) {
        if (this.clusterManager.isClustered()) {
            String nodeName;
            ClusterNodeInformation clusterNodeInformation = this.clusterManager.getThisNodeInformation();
            String string = nodeName = clusterNodeInformation != null ? clusterNodeInformation.getAnonymizedNodeIdentifier() : PSEUDO_NODENAME;
            if (clusterNodeInformation != null && LOG.isDebugEnabled()) {
                LOG.debug("onSyncClusterMessage Source=" + clusterNodeInformation.getAnonymizedNodeIdentifier());
            }
            this.eventPublisher.publish((Object)new SyncClusterMessage(nodeName, channel, message, nodeName));
        }
    }

    public void sendMessage(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SEND sendMessage=> analyze-channel3 ==> " + message);
        }
        this.sendRemote(ANALYZE_CHANNEL, message);
    }

    private String getValueWithDelay(String key) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getValueWithDelay: key={}", (Object)key);
            }
            for (int i = 0; i < 50; ++i) {
                if (key.equalsIgnoreCase(this.dao.getValue(SYNC_KEY))) {
                    String logContent = this.dao.getValue(SYNC_VALUE);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getLogWithDelay: key={}, logContent={}", (Object)key, (Object)logContent);
                    }
                    return logContent;
                }
                Thread.sleep(200L);
            }
            LOG.info("Cache value for key '" + key + "' not found after 50 retries.");
        }
        catch (Exception e) {
            LOG.error(String.format("Error while getting log with delay for key %1$s: %2$s", key, e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public String saveOnDisk(LogStats logStats) {
        File results = new File(this.sharedCachesDirectory, this.nodeName + "_results.csv");
        this.logsAnalyser.saveOnDisk(results, logStats);
        LOG.info("Processed:" + results.getAbsolutePath());
        this.updateResultFiles(results.getAbsolutePath());
        this.createResultFiles();
        return results.getAbsolutePath();
    }

    public void resetResultFiles() {
        this.dao.setValue(SYNC_FILES, "");
        this.dao.setValue(SYNC_COMBINE_FILES, "");
        ProcessingResults.getInstance().clearResult();
        File results = new File(this.sharedCachesDirectory, SYNC_RESULT);
        if (results.exists()) {
            results.delete();
        }
    }

    public boolean createResultFiles() {
        String value = this.dao.getValue(SYNC_FILES);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        String[] files = value.split(",");
        if (this.clusterManager.isClustered() && files.length != this.clusterManager.getAllNodesInformation().size()) {
            return false;
        }
        try {
            File results = new File(this.sharedCachesDirectory, SYNC_RESULT);
            this.logsAnalyser.concatenateFiles(files, results.getAbsolutePath());
            this.dao.setValue(SYNC_COMBINE_FILES, results.getAbsolutePath());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generate from:" + value + " ==>" + results.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized boolean updateResultFiles(String fileName) {
        Object value = this.dao.getValue(SYNC_FILES);
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateResultFiles : " + fileName + " <== value=" + (String)value);
        }
        value = StringUtils.isEmpty((CharSequence)value) ? fileName : (String)value + "," + fileName;
        this.dao.setValue(SYNC_FILES, (String)value);
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateResultFiles : " + fileName + " ==> value=" + (String)value);
        }
        return true;
    }

    public void analyseLogs(final String[] fileNames) {
        this.resetResultFiles();
        if (this.clusterManager.isClustered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ANALYZE_CHANNEL: analyze-channel3 fileNames=" + StringUtils.join((Object[])fileNames, (String)","));
            }
            this.sendMessage(FILE_PREFIX + StringUtils.join((Object[])fileNames, (String)","));
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("fileNames=" + StringUtils.join((Object[])fileNames, (String)","));
                    }
                    LogStats logStats = IUMClusterAnalyzer.this.logsAnalyser.extractLogs(fileNames);
                    String fileName = IUMClusterAnalyzer.this.saveOnDisk(logStats);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Saved as :" + fileName);
                    }
                    if (!IUMClusterAnalyzer.this.clusterManager.isClustered()) {
                        IUMClusterAnalyzer.this.createResultFiles();
                    }
                    return;
                }
                catch (Exception e) {
                    LOG.error("Exception:" + e.getMessage(), (Throwable)e);
                    IUMClusterAnalyzer.this.sendMessage(IUMClusterAnalyzer.ANALYZE_ERROR + e.getMessage());
                    return;
                }
            }
        });
    }

    public boolean isClustered() {
        return this.clusterManager.isClustered();
    }

    @EventListener
    public void onSyncClusterMessage(ClusterEventWrapper clusterEventWrapper) {
        Event wrappedEvent = clusterEventWrapper.getEvent();
        if (clusterEventWrapper.getEvent() instanceof SyncClusterMessage) {
            String nodeName;
            final SyncClusterMessage event = (SyncClusterMessage)wrappedEvent;
            ClusterNodeInformation clusterNodeInformation = this.clusterManager.getThisNodeInformation();
            String string = nodeName = clusterNodeInformation != null ? clusterNodeInformation.getAnonymizedNodeIdentifier() : PSEUDO_NODENAME;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onSyncClusterMessage: channel=" + event.channel + " nodeName=" + nodeName + " message=" + event.getMessage());
            }
            if (ANALYZE_CHANNEL.equals(event.channel) && !nodeName.equals(event.node) && clusterNodeInformation != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RECEIVED channel=analyze-channel3 message=" + event.getMessage());
                }
                if (!StringUtils.isEmpty((CharSequence)event.getMessage())) {
                    if (event.getMessage().startsWith(FILE_PREFIX)) {
                        this.executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    String[] files = event.getMessage().substring(IUMClusterAnalyzer.FILE_PREFIX.length()).split(",");
                                    if (files != null) {
                                        LogStats logStats = IUMClusterAnalyzer.this.logsAnalyser.extractLogs(files);
                                        String fileName = IUMClusterAnalyzer.this.saveOnDisk(logStats);
                                        IUMClusterAnalyzer.this.sendMessage(IUMClusterAnalyzer.ANALYZE_RESPONSE + fileName);
                                    } else {
                                        IUMClusterAnalyzer.this.sendMessage(IUMClusterAnalyzer.ANALYZE_ERROR);
                                    }
                                    return;
                                }
                                catch (Exception e) {
                                    LOG.error("Exception:" + e.getMessage(), (Throwable)e);
                                    IUMClusterAnalyzer.this.sendMessage(IUMClusterAnalyzer.ANALYZE_ERROR + e.getMessage());
                                    return;
                                }
                            }
                        });
                        return;
                    }
                    if (event.getMessage().startsWith(ANALYZE_RESPONSE)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Processed:RESPONSE:" + event.getMessage().substring(ANALYZE_RESPONSE.length()));
                        }
                        this.createResultFiles();
                        return;
                    }
                    if (event.getMessage().startsWith(ANALYZE_ERROR)) {
                        LOG.info("Processed:ERROR:" + event.getMessage().substring(ANALYZE_RESPONSE.length()));
                        return;
                    }
                }
            }
        }
    }

    public static class SyncClusterMessage
    extends ConfluenceEvent
    implements ClusterEvent {
        private final String channel;
        private final String message;
        private final String node;

        public SyncClusterMessage(Object src, String channel, String message, String node) {
            super(src);
            this.channel = channel;
            this.message = message;
            this.node = node;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getMessage() {
            return this.message;
        }

        public String getNode() {
            return this.node;
        }
    }
}

