/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.servlet;

import com.atlassian.confluence.setup.BootstrapManager;
import de.accxia.apps.confluence.logViewer.config.DAO;
import de.accxia.apps.confluence.logViewer.log.FileInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHttpServlet.class);
    private final BootstrapManager bootstrapManager;
    private final DAO dao;
    protected static final Comparator<File> FILE_NAME = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareToIgnoreCase(f2.getName());
        }
    };

    protected BaseHttpServlet(BootstrapManager bootstrapManager, DAO dao) {
        this.bootstrapManager = bootstrapManager;
        this.dao = dao;
    }

    protected List<Map<String, String>> listLogs() {
        try {
            File homeDir = new File(this.dao.getLogDir());
            File[] res = homeDir.listFiles();
            Arrays.sort(res, FILE_NAME);
            return FileInfo.toFileInfos(res);
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Map<String, String>> listLogs(String pattern) {
        ArrayList retVal = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = ".*";
        }
        String filePattern = pattern;
        try {
            Path dir = Paths.get(this.dao.getLogDir(), new String[0]);
            FileSystem fs = dir.getFileSystem();
            ArrayList<File> fileList = new ArrayList<File>();
            DirectoryStream.Filter<Path> filter = entry -> Files.isDirectory(entry, new LinkOption[0]) || Files.isRegularFile(entry, new LinkOption[0]) && fs.getPathMatcher("glob:" + filePattern).matches(entry.getFileName());
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, filter);){
                for (Path entry2 : stream) {
                    fileList.add(entry2.toFile());
                }
                Collections.sort(fileList, Comparator.comparing(p -> p.getName().toLowerCase()));
                fileList.forEach(p -> retVal.add(FileInfo.toMap(p)));
                ArrayList arrayList = retVal;
                return arrayList;
            }
            catch (IOException e) {
                LOG.error("Exception:" + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected List<Map<String, String>> listBackups() {
        try {
            File homeDir = new File(this.bootstrapManager.getConfiguredLocalHome(), "/backups");
            if (LOG.isDebugEnabled()) {
                LOG.debug("homeDir=" + homeDir.getPath());
            }
            File[] res = homeDir.listFiles();
            Arrays.sort(res, FILE_NAME);
            return FileInfo.toFileInfos(res);
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

