/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.servlet;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.confluence.logViewer.config.DAO;
import de.accxia.apps.confluence.logViewer.log.ProcessingResults;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/status")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestAnalyserStatus {
    private static final Logger LOG = LoggerFactory.getLogger(RestAnalyserStatus.class);
    @ComponentImport
    private final ClusterManager clusterManager;
    private final DAO dao;

    @Inject
    public RestAnalyserStatus(ClusterManager clusterManager, DAO dao) {
        this.clusterManager = clusterManager;
        this.dao = dao;
    }

    @GET
    @Path(value="/nodes")
    public Response checkParsedStatus(@Context HttpServletRequest req) throws IOException {
        String value = this.dao.getValue("SYNC_FILES");
        int syncFiles = 0;
        int nodeSize = 1;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            syncFiles = value.split(",").length;
        }
        if (this.clusterManager.isClustered()) {
            nodeSize = this.clusterManager.getAllNodesInformation().size();
        }
        LOG.info("checkParsedStatus value:" + value + " syncFiles:" + syncFiles);
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("nodes", nodeSize);
        retVal.put("completed", syncFiles);
        retVal.put("results", ProcessingResults.getInstance().getResults());
        return Response.ok(retVal).build();
    }
}

