/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.log;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingResults {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessingResults.class);
    private static ProcessingResults instance = new ProcessingResults();
    private Map<String, ProcessingResult> results = new HashMap<String, ProcessingResult>();

    private ProcessingResults() {
    }

    public static ProcessingResults getInstance() {
        return instance;
    }

    public void addResult(String fileName, Integer matchedLine) {
        if (this.results.containsKey(fileName)) {
            ProcessingResult result = this.results.get(fileName);
            result.matchedLine = matchedLine;
        } else {
            ProcessingResult result = new ProcessingResult(fileName, matchedLine);
            this.results.put(fileName, result);
        }
    }

    public void clearResult() {
        this.results.clear();
    }

    public Map<String, Integer> getResults() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, ProcessingResult> entry : this.results.entrySet()) {
            ProcessingResult pv = entry.getValue();
            result.put(pv.fileName, pv.matchedLine);
        }
        return result;
    }

    static class ProcessingResult {
        private String fileName;
        private Integer matchedLine;

        public ProcessingResult() {
        }

        public ProcessingResult(String fileName, Integer matchedLine) {
            this.fileName = fileName;
            this.matchedLine = matchedLine;
        }
    }
}

