/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.servlet;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.confluence.logViewer.config.DAO;
import de.accxia.apps.confluence.logViewer.listener.IUMClusterAnalyzer;
import de.accxia.apps.confluence.logViewer.servlet.BaseHttpServlet;
import de.accxia.apps.confluence.logViewer.servlet.LogsAnalyser;
import de.accxia.apps.confluence.logViewer.utils.ParseUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.StringJoiner;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogViewer
extends BaseHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(LogViewer.class);
    private static final long MB_2 = 0x200000L;
    private static final String CONFLUENCE = "confluence";
    private static final String JSM = "iumUser";
    private static final String ALL = "all";
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final BootstrapManager bootstrapManager;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final I18NBeanFactory i18nBeanFactory;
    private I18NBean i18nBean;
    private final DAO dao;
    private final LogsAnalyser logsAnalyser;
    private final IUMClusterAnalyzer iumClusterAnalyzer;
    private final Predicate<String[]> PREDICATE_CONFLUENCE = parts -> ((String[])parts).length >= 4 && ParseUtils.safeParseBoolean(parts[3]);
    private final Predicate<String[]> PREDICATE_IUM = parts -> ((String[])parts).length >= 5 && ParseUtils.safeParseBoolean(parts[4]);

    @Inject
    public LogViewer(WebSudoManager webSudoManager, UserManager userManager, TemplateRenderer renderer, BootstrapManager bootstrapManager, I18NBeanFactory i18nBeanFactory, DAO dao, LogsAnalyser logsAnalyser, IUMClusterAnalyzer iumClusterAnalyzer) {
        super(bootstrapManager, dao);
        this.webSudoManager = webSudoManager;
        this.userManager = userManager;
        this.bootstrapManager = bootstrapManager;
        this.renderer = renderer;
        this.dao = dao;
        this.logsAnalyser = logsAnalyser;
        this.iumClusterAnalyzer = iumClusterAnalyzer;
        this.i18nBeanFactory = i18nBeanFactory;
        this.i18nBean = this.i18nBeanFactory.getI18NBean();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            UserProfile user = this.userManager.getRemoteUser(req);
            if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
                throw new WebSudoSessionException();
            }
            String myPar = req.getParameter("action");
            if ("showLog".equals(myPar)) {
                this.viewLogs2(req, resp, req.getParameter("name"));
            } else if ("downloadFilename".equals(myPar)) {
                this.downloadFilename(resp, req.getParameter("name"));
            } else if ("deleteFile".equals(myPar)) {
                this.deleteFile(resp, req.getParameter("name"));
            } else if ("downloadResults".equals(myPar)) {
                this.downloadResults(resp, req.getParameter("type"));
            } else if ("results".equals(myPar)) {
                this.getResults(req, resp);
            } else if ("charts".equals(myPar)) {
                this.doCharts(req, resp);
            }
        }
        catch (WebSudoSessionException wes) {
            LOG.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }

    private void viewLogs2(HttpServletRequest request, HttpServletResponse response, String fileName) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        File file = new File(fileName);
        if (file.exists() && file.length() > 0x200000L) {
            response.setContentType("text/plain");
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    response.getWriter().write(line);
                    response.getWriter().write("\n");
                }
                response.getWriter().flush();
                response.getWriter().close();
                return;
            }
            catch (Exception e) {
                LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            }
        }
        context.put("fileName", fileName);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/logviewer-file.vm", context, (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            UserProfile user = this.userManager.getRemoteUser(req);
            if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
                throw new WebSudoSessionException();
            }
            String myPar = req.getParameter("action");
            if ("downloadFilename".equals(myPar)) {
                this.downloadFilename(resp, req.getParameter("name"));
            } else if ("Analyse".equals(myPar)) {
                String[] fileNames = req.getParameterValues("fn");
                this.analyseLogs(req, resp, fileNames);
                this.iumClusterAnalyzer.analyseLogs(fileNames);
            } else if ("Reset".equals(myPar)) {
                this.resetAnalyser(req, resp);
            } else if ("results".equals(myPar)) {
                this.getResults(req, resp);
            } else if ("charts".equals(myPar)) {
                this.doCharts(req, resp);
            }
        }
        catch (WebSudoSessionException wes) {
            LOG.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }

    private void analyseLogs(HttpServletRequest req, HttpServletResponse resp, String[] names) {
        try {
            resp.setContentType("text/html");
            resp.getWriter().write("<html><body>");
            for (String name : names) {
                resp.getWriter().write("<div>Processing logs from " + name + "</div>");
            }
            resp.getWriter().write("</body></html>");
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            try {
                resp.getWriter().write("Error: " + e.getMessage());
            }
            catch (IOException e1) {
                LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void doCharts(HttpServletRequest req, HttpServletResponse response) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("chartTitle", this.i18nBean.getText("logger.charts.confluence.title"));
        context.put("chartLightColorLegend", this.i18nBean.getText("logger.charts.light.confluence.title"));
        context.put("chartDarkColorLegend", this.i18nBean.getText("logger.charts.dark.confluence.title"));
        context.put("type", CONFLUENCE);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/logviewer-charts.vm", context, (Writer)response.getWriter());
    }

    private void getResults(HttpServletRequest req, HttpServletResponse resp) {
        String resultsPath = this.dao.getValue("SYNC_COMBINE_FILES");
        LOG.info("resultsPath:" + resultsPath);
        File file = new File(resultsPath);
        try {
            if (!file.exists()) {
                resp.sendError(404, "File not found");
                return;
            }
            resp.setContentType("text/csv");
            resp.setHeader("Content-Disposition", "inline; filename=results.csv");
            resp.setContentLength((int)file.length());
            try (FileInputStream in = new FileInputStream(file);
                 ServletOutputStream out = resp.getOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            try {
                resp.sendError(404, "Error reading results");
            }
            catch (IOException ex) {
                LOG.error("Exception:" + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void downloadFilename(HttpServletResponse resp, String name) {
        try {
            File file = new File(name);
            if (name != null) {
                int bytesRead;
                FileInputStream fis = new FileInputStream(name);
                BufferedInputStream bis = new BufferedInputStream(fis);
                resp.setContentType("application/octet-stream");
                resp.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = bis.read(dataBuffer, 0, 1024)) != -1) {
                    resp.getOutputStream().write(dataBuffer, 0, bytesRead);
                }
                bis.close();
                return;
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    private void deleteFile(HttpServletResponse resp, String name) {
        try {
            File file = new File(name);
            if (file.exists()) {
                file.delete();
                resp.getWriter().write("File deleted successfully");
                return;
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    private void downloadResults(HttpServletResponse resp, String type) throws IOException {
        File file;
        String fileName = this.dao.getValue("SYNC_COMBINE_FILES");
        if (LOG.isDebugEnabled()) {
            LOG.debug("about download fileName:" + fileName);
        }
        if (!(file = new File(this.dao.getValue("SYNC_COMBINE_FILES"))).exists()) {
            resp.sendError(404, "File not found");
            return;
        }
        if (ALL.equals(type)) {
            this.downloadOriginalResults(resp, file);
            return;
        }
        Predicate<String[]> PREDICATE = this.PREDICATE_CONFLUENCE;
        String downloadFileName = this.i18nBean.getText("logger.results.confluence.filename");
        resp.setContentType("application/octet-stream");
        resp.setHeader("Content-Disposition", "attachment; filename=" + downloadFileName);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            String headerLine = reader.readLine();
            String processedHeaderLine = StringUtils.join((Object[])headerLine.split(","), (String)",", (int)0, (int)3);
            resp.getOutputStream().write(processedHeaderLine.getBytes());
            resp.getOutputStream().write("\n".getBytes());
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                if (!PREDICATE.test(parts)) continue;
                StringJoiner stringJoiner = new StringJoiner(",");
                stringJoiner.add(parts[0]);
                if (!StringUtils.isEmpty((CharSequence)parts[1])) {
                    stringJoiner.add(parts[1].split(":")[0]);
                } else {
                    stringJoiner.add(parts[1]);
                }
                stringJoiner.add(parts[2]);
                String processedLine = stringJoiner.toString();
                resp.getOutputStream().write(processedLine.getBytes());
                resp.getOutputStream().write("\n".getBytes());
            }
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        try {
            resp.getOutputStream().flush();
            resp.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    private void downloadOriginalResults(HttpServletResponse resp, File file) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int bytesRead;
            resp.setContentType("application/octet-stream");
            resp.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = bis.read(dataBuffer, 0, 1024)) != -1) {
                resp.getOutputStream().write(dataBuffer, 0, bytesRead);
            }
            return;
        }
        catch (FileNotFoundException e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            resp.sendError(404, "File not found");
            return;
        }
    }

    private void resetAnalyser(HttpServletRequest req, HttpServletResponse resp) {
        resp.setContentType("text/html");
        this.iumClusterAnalyzer.resetResultFiles();
        try {
            resp.getWriter().write("<html><body><h1>Analyzer has been reset</h1></body></html>");
        }
        catch (IOException e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
    }
}

