/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.servlet;

import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.accxia.apps.confluence.logViewer.config.DAO;
import de.accxia.apps.confluence.logViewer.log.LogStat;
import de.accxia.apps.confluence.logViewer.log.LogStats;
import de.accxia.apps.confluence.logViewer.log.PivotData;
import de.accxia.apps.confluence.logViewer.log.RoleCounts;
import de.accxia.apps.confluence.logViewer.servlet.LogsAnalyser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/charts")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestChartsData {
    private static final Logger LOG = LoggerFactory.getLogger(RestChartsData.class);
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final Predicate<LogStat> PREDICATE_BOTH = logStat -> logStat.confluenceRole && logStat.iumRole;
    private static final Predicate<LogStat> PREDICATE_CONFLUENCE = logStat -> logStat.confluenceRole;
    private static final Predicate<LogStat> PREDICATE_IUM = logStat -> !logStat.confluenceRole && logStat.iumRole;
    @ComponentImport
    private final I18NBeanFactory i18nBeanFactory;
    private I18NBean i18nBean;
    private final LogsAnalyser logsAnalyser;
    private final DAO dao;
    private static final Comparator<String> withComparatorLocalDate = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            LocalDate date1 = RestChartsData.convertToDate(o1);
            LocalDate date2 = RestChartsData.convertToDate(o2);
            return date1.compareTo(date2);
        }
    };
    private static final List<String> possibleFormats = Arrays.asList("dd/MMM/yyyy", "dd/MM/yyyy", "MMM-dd-yyyy", "MM-dd-yyyy", "yyyy-MMM-dd", "yyyy-MM-dd", "dd MMM yyyy", "dd MM yyyy", "MMM dd, yyyy", "MM dd, yyyy");

    @Inject
    public RestChartsData(I18NBeanFactory i18nBeanFactory, LogsAnalyser logsAnalyser, DAO dao) {
        this.logsAnalyser = logsAnalyser;
        this.dao = dao;
        this.i18nBeanFactory = i18nBeanFactory;
        this.i18nBean = this.i18nBeanFactory.getI18NBean();
    }

    @GET
    @Path(value="/")
    public Response charts(@Context HttpServletRequest req) {
        try {
            String type = "confluence";
            String resultsPath = this.dao.getValue("SYNC_COMBINE_FILES");
            LOG.info("resultsPath:" + resultsPath);
            LogStats ls = this.logsAnalyser.loadFromCSV(new File(resultsPath));
            Map<String, Map<Integer, RoleCounts>> daysUsersPerHours = RestChartsData.createPivot(ls, "confluence");
            PivotData pivotData = new PivotData();
            HashMap retVal = new HashMap();
            if (!"confluence".equalsIgnoreCase(type)) {
                this.addIUMLabels(pivotData);
            } else {
                this.addConfluenceLabels(pivotData);
            }
            pivotData.setType(type);
            pivotData.setData(daysUsersPerHours);
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)JsonFactory.builder().build());
            objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            String dtoAsString = objectMapper.writeValueAsString(pivotData);
            return Response.ok((Object)dtoAsString).build();
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error reading file: " + e.getMessage())).build();
        }
    }

    private void addConfluenceLabels(PivotData pivotData) {
        pivotData.setBothAccess(this.i18nBean.getText("logger.both.access"));
        pivotData.setOnlyAccess(this.i18nBean.getText("logger.jira.access"));
    }

    private void addIUMLabels(PivotData pivotData) {
        pivotData.setBothAccess(this.i18nBean.getText("logger.both.access"));
        pivotData.setOnlyAccess(this.i18nBean.getText("logger.jsm.access"));
    }

    public static Map<String, Map<Integer, RoleCounts>> createPivot(LogStats logStatistics, String type) {
        Map retVal = logStatistics.logStats.stream().collect(Collectors.groupingBy(LogStat::getDate, () -> new TreeMap(withComparatorLocalDate), Collectors.groupingBy(logStat -> LocalTime.parse(logStat.time, TIME_FORMATTER).getHour(), Collectors.collectingAndThen(Collectors.toList(), list -> {
            long role1Count = list.stream().filter(PREDICATE_CONFLUENCE).map(LogStat::getUser).distinct().count();
            return new RoleCounts(role1Count, 0L);
        }))));
        return retVal;
    }

    private LogStats loadFromCSV() {
        LogStats ls = new LogStats();
        try (InputStream in = RestChartsData.class.getResourceAsStream("/results.csv");
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                if (parts.length < 3) continue;
                String date = parts[0];
                String time = parts[1];
                String user = parts[2];
                String jira = parts.length >= 4 ? parts[3] : "false";
                String jsm = parts.length >= 5 ? parts[4] : "false";
                LogStat logStat = new LogStat(user, date, time, "", Boolean.parseBoolean(jira), Boolean.parseBoolean(jsm));
                ls.logStats.add(logStat);
            }
        }
        catch (Exception e) {
            LOG.error("Exception:" + e.getMessage(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            for (LogStat logStat : ls.logStats) {
                LOG.debug("LogStat: " + logStat.user + " " + logStat.date + " " + logStat.time);
            }
        }
        return ls;
    }

    private static LocalDate convertToDate(String dateString) {
        for (String format : possibleFormats) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                LocalDate date = LocalDate.parse(dateString, formatter);
                LOG.debug("Detected format: " + format);
                return date;
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return LocalDate.now();
    }

    private static String getHourFromTime(String time) {
        try {
            LocalTime lt = LocalTime.parse(time, TIME_FORMATTER);
            return String.format("%02d", lt.getHour());
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public Map<String, Map<Integer, Long>> analyseLogs(HttpServletRequest req, String appName) {
        int type = "jira".equalsIgnoreCase(appName) ? 1 : 2;
        String resultsPath = this.dao.getValue("SYNC_COMBINE_FILES");
        LOG.info("resultsPath:" + resultsPath);
        LogStats ls = this.logsAnalyser.loadFromCSV(new File(resultsPath));
        Map<String, Map<Integer, Map<String, Long>>> original = ls.logStats.stream().collect(Collectors.groupingBy(logStat -> logStat.date, Collectors.groupingBy(logStat -> LocalTime.parse(logStat.time, TIME_FORMATTER).getHour(), Collectors.groupingBy(logStat -> logStat.user, Collectors.counting()))));
        TreeMap<String, Map<Integer, Long>> result = new TreeMap<String, Map<Integer, Long>>(withComparatorLocalDate);
        for (Map.Entry<String, Map<Integer, Map<String, Long>>> outerEntry : original.entrySet()) {
            String outerKey = outerEntry.getKey();
            Map<Integer, Map<String, Long>> innerMap = outerEntry.getValue();
            TreeMap<Integer, Long> aggregatedInner = new TreeMap<Integer, Long>();
            for (Map.Entry<Integer, Map<String, Long>> midEntry : innerMap.entrySet()) {
                Integer midKey = midEntry.getKey();
                Map<String, Long> valueMap = midEntry.getValue();
                long count = valueMap.values().stream().mapToLong(Long::longValue).count();
                aggregatedInner.put(midKey, count);
            }
            result.put(outerKey, aggregatedInner);
        }
        return result;
    }
}

