/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.logViewer.servlet;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import de.accxia.apps.confluence.logViewer.listener.IUMClusterAnalyzer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/test")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestClusterTest {
    private static final Logger LOG = LoggerFactory.getLogger(RestClusterTest.class);
    @ComponentImport
    private final BootstrapManager bootstrapManager;
    @ComponentImport
    private final ClusterManager clusterManager;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    private final IUMClusterAnalyzer iumClusterAnalyzer;

    @Inject
    public RestClusterTest(BootstrapManager bootstrapManager, ClusterManager clusterManager, ApplicationProperties applicationProperties, IUMClusterAnalyzer iumClusterAnalyzer) {
        this.bootstrapManager = bootstrapManager;
        this.clusterManager = clusterManager;
        this.applicationProperties = applicationProperties;
        this.iumClusterAnalyzer = iumClusterAnalyzer;
    }

    @GET
    @Path(value="/fn")
    public Response readFile(@Context HttpServletRequest req, @QueryParam(value="filename") String filename) throws IOException {
        String body = this.readSharedFile(filename);
        return Response.ok((Object)body).build();
    }

    @GET
    @Path(value="/node")
    public Response getNodes(@Context HttpServletRequest req) throws IOException {
        Collection nodes = this.clusterManager.getAllNodesInformation();
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        for (ClusterNodeInformation node : nodes) {
            HashMap<String, String> nodeInfo = new HashMap<String, String>();
            nodeInfo.put("AnonymizedNodeIdentifier", node.getAnonymizedNodeIdentifier());
            nodeInfo.put("humanReadableNodeName", (String)(node.humanReadableNodeName().isPresent() ? node.humanReadableNodeName().get() : "missing humanReadableNodeName"));
            nodeInfo.put("LocalSocketAddress", node.getLocalSocketAddress().toString());
            retVal.put(node.getAnonymizedNodeIdentifier(), nodeInfo);
        }
        retVal.put("applicationProperties", this.applicationProperties.getSharedHomeDirectory());
        return Response.ok(retVal).build();
    }

    @GET
    @Path(value="/msg")
    public Response sendMessage(@Context HttpServletRequest req, @QueryParam(value="message") String message) throws IOException {
        this.iumClusterAnalyzer.sendMessage(message);
        return Response.ok((Object)message).build();
    }

    public String readSharedFile(String filename) throws IOException {
        File sharedHome = this.bootstrapManager.getLocalHome();
        File targetFile = new File(sharedHome, filename);
        if (!targetFile.exists()) {
            throw new IOException("File does not exist: " + targetFile.getAbsolutePath());
        }
        return Files.readString(targetFile.toPath());
    }

    public static String findTomcatFileOrDirectory(String fileOrDirectoryName) {
        String catalinaBase = System.getProperty("catalina.base");
        File file = new File(catalinaBase, fileOrDirectoryName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        String catalinaHome = System.getProperty("catalina.home");
        file = new File(catalinaHome, fileOrDirectoryName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        String workingDirectory = System.getProperty("working.dir");
        file = new File(workingDirectory + "../", fileOrDirectoryName);
        return file.exists() ? file.getAbsolutePath() : null;
    }
}

